<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	if(isset($_REQUEST['btnSubmit']))
	{
		update_return($db,$URL,$_REQUEST['rid']);
	}

	if(isset($_REQUEST['btnFinalize']))
	{
		finalize_return($db,$URL,$_REQUEST['rid']);
	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Update Return</title>
	
	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>
	
	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>
	<!-- CKEditor -->
	<script src="js/plugins/ckeditor/ckeditor.js"></script>
	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>
	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.ico" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
	<script type="text/javascript">
		function update_returndetail(rdid,field,value)
		{
			var url	  		= "update_returndetail.php?rdid="+rdid+"&field="+field+"&value="+value;
			//alert(url);return false;
			var containerid = "ShowUpdateReturn";
			return GetPage(url, containerid);
		}
		function cancel_return(rid)
		{
			var cd;
			cd = confirm("Are you sure to cancel return?");
			if(cd)
			{
				var url	  		= "cancel_return.php?rid="+rid;
				window.location.replace(url);
			}
		}
		function finalize_return(rid)
		{
			var cd;
			cd = confirm("Are you sure to finalize return?");
			if(cd)
			{
				var url	= "finalize_return.php?rid="+rid;
				window.location.href(url);
			}
		}
	</script>
</head>

<body class='theme-grey'>
	<!-- HEADER START -->
	<?php include("top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.html" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>Update Return & Replacement</h1>
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="returns.php">Return & Replacement</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="add_return.php">Create New Return</a>
						</li>
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<form name="Form" action="#" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
									<div id="ShowUser"></div>
									<div id="GetProduct"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-danger alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
										if($_REQUEST['invid'] <> 0)
										{
											$query = $db->prepare("SELECT * FROM returns R INNER JOIN invoices INV ON R.invid = INV.invid WHERE R.rid=?");
											$query->execute(array($_REQUEST['rid']));
											while($row = $query->fetch())
											{
												$invid = $row['invid'];
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Return No</label>
										<div class="col-sm-10">
											RT-<?php echo($row['rid']); ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Invoice No</label>
										<div class="col-sm-10">
											INV-<?php echo($row['invid']); ?>
										</div>
									</div>
									<?php if($row['order_number'] != 0){ ?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Shopify Order</label>
										<div class="col-sm-10">
											<?php echo($row['order_number']); ?>
										</div>
									</div>
									<?php } ?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Customer</label>
										<div class="col-sm-10">
											<?php echo($row['invname']); ?>, <?php echo($row['invemail']); ?>, <?php echo($row['invmobileno']); ?>, <?php echo($row['invaddress']); ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Image</label>
										<div class="col-sm-7">
											<?php if($row['rimage'] != ""){ ?><img src="images/returns/<?php echo($row['rimage']); ?>" width="250"><?php } ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Remarks</label>
										<div class="col-sm-10"><?php echo($row['remarks']); ?></div>
									</div>
									<?php
											}
										}
										else
										{
											$query = $db->prepare("SELECT * FROM returns WHERE rid=?");
											$query->execute(array($_REQUEST['rid']));
											while($row = $query->fetch())
											{
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Return No</label>
										<div class="col-sm-10">
											RT-<?php echo($row['rid']); ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Remarks</label>
										<div class="col-sm-10">
											<?php echo($row['remarks']); ?>
										</div>
									</div>
									<?php		
											}
										}		
									?>
								</div>
									
							</div>
							<?php
								if(isset($_REQUEST['rid'])){
							?>
							<div class="form-group" style="background-color:#CCC; ">
								<label for="textfield" class="control-label col-sm-2"><b>Return Detail</b></label>
							</div>
							<div class="form-group">
									<div id="ShowUpdateReturn"></div>
									<?php
										$count = 0;
										$requery = $db->prepare("SELECT * FROM returndetail RT INNER JOIN product_barcodes PB ON RT.return_barcode = PB.barcode 
																 INNER JOIN products P ON PB.pid = P.pid
																 INNER JOIN maincategory M ON P.id = M.id INNER JOIN category C ON P.cid = C.cid 
																 INNER JOIN product_sizes PS ON PB.szid = PS.szid WHERE RT.rid=? ORDER BY PB.bcid ASC");
										$requery->execute(array($_REQUEST['rid']));
										while($rerow = $requery->fetch()){
											$count++;
											$pid = $rerow['pid'];
											$szid = $rerow['szid'];
											$replace_barcode = $rerow['replace_barcode'];
									?>
									<div class="col-sm-12">	
										<div class="form-group">
											<div class="col-sm-6">		
												<input type="hidden" name="hdnPID<?php echo($count); ?>" value="<?php echo($rerow['pid']); ?>">
												<?php echo($rerow['maincategory']); ?> - <?php echo($rerow['category']); ?> - <?php echo($rerow['pname']); ?> - <?php echo($rerow['sku']); ?> - <?php echo($rerow['barcode']); ?>			
											</div>
											<div class="col-sm-2">
												<input type="text" name="txtReplaceBarCode<?php echo($count); ?>" value="<?php echo($rerow['replace_barcode']); ?>" class="form-control">			
											</div>
											<div class="col-sm-2">
												<select name="cboType<?php echo($count); ?>" class="form-control" onChange="return update_returndetail(<?php echo($rerow['rdid']); ?>,'amount_type',this.value);">
													<option <?php if($rerow['amount_type'] == 1) { echo("SELECTED"); } ?> value="1">Refund</option>
													<option <?php if($rerow['amount_type'] == 2) { echo("SELECTED"); } ?> value="2">Surplus</option>
												</select>			
											</div>
											<div class="col-sm-2">
												<input type="number" name="txtAmount<?php echo($count); ?>" value="<?php echo($rerow['amount']); ?>" onChange="return update_returndetail(<?php echo($rerow['rdid']); ?>,'amount',this.value);" class="form-control">			
											</div>													
										</div>
									</div>
									<?php } ?>
								</div>
							</div>
							<div id="newRow"></div>
							
							
							<?php } ?>
						</div>
					</div>
					<div class="form-actions">
						<input name="btnSubmit" type="submit" class="btn btn-primary" value="  Save  ">
						<input name="btnFinalize" type="submit" class="btn btn-success" value="  Finalize  ">
						<button name="btnCancel" type="submit" onclick="return cancel_return(<?php echo($_REQUEST['rid']); ?>);" class="btn">Cancel</button>
					</div>
				</div>		
				</form>
			</div>
		</div>
	</div>
</body>
</html>
