<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	if(isset($_REQUEST['btnSubmit']))
	{
		update_rawmaterial($db,$URL,$_REQUEST['rid']);
	}
	if(isset($_REQUEST['btnCancel']))
	{
		header("Location: rawmaterials.php?");
	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Update Raw Material</title>
	
	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>
	
	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>
	<!-- CKEditor -->
	<script src="js/plugins/ckeditor/ckeditor.js"></script>
	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
	<script type="text/javascript">
		function getrawcategory(rmid)
		{
			var url	  		= "chk_rawcategory.php?rmid="+rmid;
			var containerid = "ShowRawCategory";
			return GetPage(url, containerid);
		}
	</script>
</head>

<body class='theme-grey'>
<!-- HEADER START -->
	<?php include("top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.php" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>Update Raw Material</h1>
					</div>
					<div class="pull-right">
	<img src="images/dazzle_logo.jpg" width="150" alt="">
		
	</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="rawmaterials.php">Manage Raw Material</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="addrawmaterial.php">Create Raw Material</a>
						</li>
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<form name="Form" action="#" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
									<div id="ShowUser"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-success alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
										$query = $db->prepare("SELECT * FROM rawmaterials WHERE rid=?");
										$query->execute(array($_REQUEST['rid']));
										while($row = $query->fetch())
										{
											$rmid = $row['rmid'];
											$rcid = $row['rcid'];
											$hdn_image = $row['rimage'];

											$color 	  = $row['rcolor'];
											$unittype = $row['unittype'];
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Main Category</label>
										<div class="col-sm-10">
											<select name="cboMainCategory" disabled class="control-label col-sm-4">
												<?php
													$rmquery = $db->prepare("SELECT * FROM rmaincategory  WHERE rmid=?");
													$rmquery->execute(array($rmid));
													while($rmrow = $rmquery->fetch())
													{
												?>
												<option value="<?php echo($rmrow['rmid']); ?>"><?php echo($rmrow['rmaincategory']); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Category</label>
										<div class="col-sm-10" id="ShowRawCategory">
											<select name="cboCategory" disabled class="control-label col-sm-4">
												<?php
													$rcquery = $db->prepare("SELECT * FROM rcategory  WHERE rcid=?");
													$rcquery->execute(array($rcid));
													while($rcrow = $rcquery->fetch())
													{
												?>
												<option value="<?php echo($rcrow['rcid']); ?>"><?php echo($rcrow['rcategory']); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Name</label>
										<div class="col-sm-10">
											<input type="text" name="txtName" value="<?php echo(htmlentities($row['rname'])); ?>" id="textfield" class="form-control" data-rule-required="true" data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Article #</label>
										<div class="col-sm-10">
											<input type="text" name="txtArticleNo" value="<?php echo(htmlentities($row['rarticleno'])); ?>" id="textfield" class="form-control" data-rule-required="true" data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Color</label>
										<div class="col-sm-10">
											<select name="cboColor" class="control-label col-sm-4">
												<option value="">Select Color</option>
												<?php
													$clquery = $db->prepare("SELECT * FROM colors ORDER BY color ASC");
													$clquery->execute();
													while($clrow = $clquery->fetch())
													{
												?>
												<option <?php if($color == $clrow['color']) { echo("SELECTED"); } ?> value="<?php echo($clrow['color']); ?>"><?php echo($clrow['color']); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Unit Type</label>
										<div class="col-sm-10">
											<select name="cboUnitType" class="control-label col-sm-4">
												<option value="">Select Unit Type</option>
												<?php
													$uquery = $db->prepare("SELECT * FROM unittype ORDER BY unittype ASC");
													$uquery->execute();
													while($urow = $uquery->fetch())
													{
												?>
												<option <?php if($unittype == $urow['unittype']) { echo("SELECTED"); } ?> value="<?php echo($urow['unittype']); ?>"><?php echo($urow['unittype']); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Price</label>
										<div class="col-sm-10">
											<input type="text" name="txtPrice" value="<?php echo($row['rprice']); ?>" id="textfield" class="form-control" data-rule-required="true" data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Image</label>
										<div class="col-sm-10">
											<input type="file" name="image" id="image" class="form-control" data-rule-required="false" data-rule-minlength="2">
											<input type="hidden" name="hdnImage" value="<?php echo($hdn_image); ?>">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Description</label>
										<div class="col-sm-10">
											<textarea name="txtDescription" class='ckeditor span12' rows="5"><?php echo($row['rdescription']); ?></textarea>
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Status</label>
										<div class="col-sm-10">
											<select name="cboStatus" class="control-label col-sm-2">
												<option <?php if($row['rstatus'] == 0) { echo("SELECTED"); } ?> value="0">Active</option>
												<option <?php if($row['rstatus'] == 1) { echo("SELECTED"); } ?> value="1">Inactive</option>
											</select>
										</div>
									</div>
									<?php } ?>
								</div>	
							</div>
						</div>
					</div>
					<div class="form-actions">
						<input name="btnSubmit" type="submit" class="btn btn-primary" value="  Save  ">
						<input name="btnCancel" type="submit" class="btn" value="  Cancel  ">
					</div>
				</div>
				
				
				</form>
			</div>
		</div>
	</div>
</body>
</html>
