<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	if($UserEditCustomer == 0){ header("Location: main.php"); }
	
	if(isset($_REQUEST['btnSubmit']))
	{
		update_customer($db,$URL,$_REQUEST['aid']);
	}

	if(isset($_REQUEST['btnSend']))
	{
		send_password($db,$URL,$_REQUEST['aid']);
	}

	if(isset($_REQUEST['btnReset']))
	{
		reset_password($db,$URL,$_REQUEST['aid']);
	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Update Customer</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script type="text/javascript" language="javascript">
		function SendLogin(aid)
		{
			var cd;
			cd = confirm("Are you sure to send login details?");
			if(cd)
			{
				var url   = "send_login_details.php?aid="+aid;
				document.Form.mothod = "post";
				document.Form.action = url;
				document.Form.submit();
			}	
		}

		function ResetPassword(aid)
		{
			var cd;
			cd = confirm("Are you sure to reset customer password?");
			if(cd)
			{
				var url   = "reset_password.php?aid="+aid;
				document.Form.mothod = "post";
				document.Form.action = url;
				document.Form.submit();
			}	
		}
		function PrintInvoice(invid)
		{
			window.open( "print_gen_invoice.php?invid="+invid , "myWindow", "status = 1, scrollbars=1, height = 650, WIDTH= 900, resizable = 1, top = 0" )
		}
		function PrintAmenityReport(aid,subid,amtype)
		{
			window.open( "print_customer_amenity_report.php?aid="+aid+"&subid="+subid+"&amtype="+amtype+"&startdate=&enddate=", "myWindow", "status = 1, scrollbars=1, height = 1000, WIDTH= 1100, resizable = 1, top = 0" )
		}
	</script>
	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple <div></div>evices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
	
</head>

<body class='theme-grey'>
<!-- HEADER START -->
	<?php include("top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.php" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>Update Cutomer</h1>
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="customers.php">Manage Customers</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="addcustomer.php">Create New Customer</a>
						</li>
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<?php
					$query = $db->prepare("SELECT * FROM accounts WHERE aid = ?");
					$query->execute(array($_REQUEST['aid']));
					while($row = $query->fetch())
					{
						$Aid = $row['aid'];
						$gtno = $row['gtno'];
						$Lid = $row['lid'];
						
				?>
				<form name="Form" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
								
									<div id="ShowCustomer"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-success alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">GT Number</label>
										<div class="col-sm-10">
											<input type="text" name="txtGtNo" id="textfield" disabled value="<?php echo($row['gtno']); ?>" class="form-control">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Select Location</label>
										<div class="col-sm-10">
											<select disabled name="cboLocation" class="control-label col-sm-4">
												<?php
													if($User_Type != 0) { $l1 = "WHERE lid = ".$UserLid; } else{ $l1 = ""; }
													$lquery = $db->prepare("SELECT * FROM locations $l1 ORDER BY lname ASC");
													$lquery->execute();
													while($lrow = $lquery->fetch())
													{
												?>
												<option <?php if($lrow['lid'] == $Lid) { echo("SELECTED"); } ?> value="<?php echo($lrow['lid']); ?>"><?php echo($lrow['lname']); ?></option>
												<?php
													}
												?>
											</select>
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Account Name <span style="color: red;">*</span></label>
										<div class="col-sm-10">
											<input type="text" name="txtName" id="textfield" value="<?php echo($row['aname']); ?>" class="form-control" data-rule-required="true" data-rule-minlength="2">
										</div>
									</div>
									
									<div class="form-group">
										<label for="emailfield" class="control-label col-sm-2">Email</label>
										<div class="col-sm-10">
											<input type="text" name="txtEmail" id="emailfield" value="<?php echo($row['aemail']); ?>" class="form-control" data-rule-email="true" onchange="return chkMemner(this.value);" data-rule-required="true">
										</div>
									</div>

									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">CNIC Number <span style="color: red;">*</span></label>
										<div class="col-sm-10">
											<input type="text" name="txtCnic" id="textfield" value="<?php echo($row['cnic']); ?>" class="form-control" data-rule-minlength="2">
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Address <span style="color: red;">*</span></label>
										<div class="col-sm-10">
											<input type="text" name="txtAddress" id="textfield" value="<?php echo($row['aaddress']); ?>" class="form-control" data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">City</label>
										<div class="col-sm-10">
											<input type="text" name="txtCity" id="textfield" value="<?php echo($row['acity']); ?>" class="form-control">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Phone</label>
										<div class="col-sm-10">
											<input type="text" name="txtPhone" id="textfield" value="<?php echo($row['aphone']); ?>" class="form-control">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Mobile <span style="color: red;">*</span></label>
										<div class="col-sm-10">
											<input type="text" name="txtMobile" id="textfield" value="<?php echo($row['amobile']); ?>" class="form-control" data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Business Type</label>
										<div class="col-sm-10">
											<input type="text" name="txtBusinessType" id="textfield" value="<?php echo($row['businesstype']); ?>" class="form-control">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Business Detail</label>
										<div class="col-sm-10">
											<textarea class="form-control" name="txtBusinessDetail" style="height: 150px;"><?php echo($row['businessdetail']); ?></textarea>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Company Name</label>
										<div class="col-sm-10">
											<input type="text" name="txtCompanyName" id="textfield" value="<?php echo($row['aconame']); ?>" class="form-control">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Company Address</label>
										<div class="col-sm-10">
											<input type="text" name="txtCompanyAddress" value="<?php echo($row['acoaddress']); ?>" id="textfield" class="form-control">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Company Phone</label>
										<div class="col-sm-10">
											<input type="text" name="txtCompanyPhone" value="<?php echo($row['acophone']); ?>" id="textfield" class="form-control">
										</div>
									</div>	
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Portal Login Status</label>
										<div class="col-sm-10">
											<select name="cboStatus" class="control-label col-sm-4">
												<option <?php if($row['astatus'] == 0){ echo("SELECTED"); } ?> value="0">Enabled</option>
												<option <?php if($row['astatus'] == 1){ echo("SELECTED"); } ?> value="1">Disabled</option>
											</select> 
											&nbsp;<span style="color: red; font-size: 11px;">Note: if the customer is disabled admin cannot create invoices or amenity entries against them</span>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Archive Status</label>
										<div class="col-sm-10">
											<select name="cboArchive" class="control-label col-sm-4">
												<option <?php if($row['acarchived'] == 0){ echo("SELECTED"); } ?> value="0">Active</option>
												<option <?php if($row['acarchived'] == 1){ echo("SELECTED"); } ?> value="1">Archived</option>
											</select>
											&nbsp;&nbsp;
											<?php if($row['acarchived'] == 1){ ?>
											<input type="checkbox" name="chkUnArchived" value="1">
											<span style="color: red; font-weight: bold;">Note: Check this to Un Archive All the Memberships and Sub Members related to this Customer</span>
											<?php } ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Login Details Sent On</label>
										<div class="col-sm-10">
											<?php if($row['passdate'] == 0){ ?>Never<?php }else{ echo(date("d-m-Y h:i A",$row['passdate'])); } ?>
										</div>
									</div>
								</div>	
							</div>
						</div>
					</div>
				</div>
				<?php
					$aquery = $db->prepare("SELECT * FROM arights WHERE aid=?");
					$aquery->execute(array($Aid));
					if($aquery->rowCount() == 0)
					{
				?>
				<div class="row">
					<div class="col-sm-12">
						<div class="box box-bordered box-color">
							<div class="box-title">
								<h3>
									<i class="fa fa-bars"></i>
									Customer Rights
								</h3>
							</div>
							<div class="box-content nopadding">
								<div class="tabs-container">
									<ul class="tabs tabs-inline tabs-left">
										<li class='active'>
											<a href="#first" data-toggle='tab'>
												<i class="fa fa-lock"></i>Assign Rights</a>
										</li>
										<li>
											<a href="#second" data-toggle='tab'><i class="glyphicon-log_book"></i> Booking Rights</a>
										</li>
									</ul>
								</div>
								<div class="tab-content padding tab-content-inline" style="min-height:100px;">
									<div class="tab-pane active" id="first">
										<div class="panel-group panel-widget" id="ac4">
											<div class="panel panel-default">
											<table width="100%" cellpadding="5" cellspacing="1">												
												<tr><td height="15"></td></tr>
												<tr>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights1" id="chkRights1" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights1">Memberships</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights2" id="chkRights2" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights2">Invoices</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights3" id="chkRights3" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights3">Conference Booking</label>
													</td>
												</tr>
												<tr><td height="15"></td></tr>
												<tr>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights4" id="chkRights4" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights4">Meeting Booking</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights5" id="chkRights5" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights5">Update Profile</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights6" id="chkRights6" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights6">Update Password</label>
													</td>
												</tr>
												<tr><td height="15"></td></tr>
												<tr>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights7" id="chkRights7" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights7">Support</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights8" id="chkRights8" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights8">Notifications</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights9" id="chkRights9" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights9">Membership Amenities</label>
													</td>
												</tr>
												<tr><td height="15"></td></tr>
												<tr>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights10" id="chkRights10" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights10">Amenity Report</label>
													</td>
												</tr>													
											</table>	
											</div>
										</div>
										<!-- /.panel-group -->
									</div>
									<div class="tab-pane" id="second">
										<div class="panel-group panel-widget" id="ac4">
											<div class="panel panel-default">
											<table width="100%">
												<tr>
													<td align="left" valign="top">
													<table width="450" cellpadding="0" cellspacing="0">												
														<tr><td height="15"></td></tr>
														<tr>
															<td>&nbsp;</td>
															<td>
																<label class='inline' for="chkRights1"><b>Conference Rooms</b></label>
															</td>
														</tr>
														<?php
															$slquery1 = $db->prepare("SELECT * FROM slots WHERE sltype = 1 ORDER BY slid ASC");
															$slquery1->execute();
															while($slrow1 = $slquery1->fetch())
															{
														?>
														<tr>
															<td>&nbsp;</td>
															<td width="550">
																&nbsp;
																<input type="checkbox" name="chkConference[]" <?php if($slrow1['slid'] == 8) { echo("checked"); } ?> id="chkConference<?php echo($slrow1['slid']); ?>" value="<?php echo($slrow1['slid']); ?>" class='icheck-me' data-skin="square" data-color="blue">
																<label class='inline' for="chkConference<?php echo($slrow1['slid']); ?>"><?php echo($slrow1['sltitle']); ?></label>
															</td>
														</tr>
														<?php }?>
														<tr><td>&nbsp;</td></tr>
														<tr>
															<td>&nbsp;</td>
															<td>
																<label class='inline' for="chkRights1"><b>Meeting Rooms</b></label>
															</td>
														</tr>
														<?php
															$slquery2 = $db->prepare("SELECT * FROM slots WHERE sltype = 2 ORDER BY slid ASC");
															$slquery2->execute();
															while($slrow2 = $slquery2->fetch())
															{
														?>
														<tr>
															<td>&nbsp;</td>
															<td>
																&nbsp;
																<input type="checkbox" name="chkMeeting[]" <?php if($slrow2['slid'] == 12) { echo("checked"); } ?> id="chkMeeting<?php echo($slrow2['slid']); ?>" value="<?php echo($slrow2['slid']); ?>" class='icheck-me' data-skin="square" data-color="blue">
																<label class='inline' for="chkMeeting<?php echo($slrow2['slid']); ?>"><?php echo($slrow2['sltitle']); ?></label>
															</td>
														</tr>
														<?php }?>
													</table>	
													</td>
													<td align="left" valign="top">
													
													</td>
												</tr>
											</table>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php
					}
					else
					{
						while($arow = $aquery->fetch())
						{
				?>
				<div class="row">
					<div class="col-sm-12">
						<div class="box box-bordered box-color">
							<div class="box-title">
								<h3>
									<i class="fa fa-bars"></i>
									Customer Rights
								</h3>
							</div>
							<div class="box-content nopadding">
								<div class="tabs-container">
									<ul class="tabs tabs-inline tabs-left">
										<li class='active'>
											<a href="#first" data-toggle='tab'>
												<i class="fa fa-lock"></i>Assign Rights</a>
										</li>
										<li>
											<a href="#second" data-toggle='tab'><i class="glyphicon-log_book"></i> Booking Rights</a>
										</li>
										<li>
											<a href="#third" data-toggle='tab'><i class="glyphicon-keys"></i> Amenities</a>
										</li>
										<li>
											<a href="#fourth" data-toggle='tab'><i class="glyphicon-book"></i> Memberships</a>
										</li>
										<li>
											<a href="#fifth" data-toggle='tab'><i class="glyphicon-group"></i> Members</a>
										</li>
										<li>
											<a href="#sixth" data-toggle='tab'><i class="glyphicon-file"></i> Invoices</a>
										</li>
										<li>
											<a href="#seventh" data-toggle='tab'><i class="fa fa-money"></i> Transactions</a>
										</li>
									</ul>
								</div>
								<div class="tab-content padding tab-content-inline" style="min-height:100px;">
									<div class="tab-pane active" id="first">
										<div class="panel-group panel-widget" id="ac4">
											<div class="panel panel-default">
											<table width="100%" cellpadding="5" cellspacing="1">												
												<tr><td height="15"></td></tr>
												<tr>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights1" <?php if($arow['membership'] == 1) { echo("CHECKED"); } ?> id="chkRights1" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights1">Memberships</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights2" <?php if($arow['invoice'] == 1) { echo("CHECKED"); } ?> id="chkRights2" value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights2">Invocies</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights3" id="chkRights3" <?php if($arow['conference_booking'] == 1) { echo("CHECKED"); } ?> value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights3">Conference Booking</label>
													</td>
												</tr>
												<tr><td height="15"></td></tr>
												<tr>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights4" id="chkRights4" <?php if($arow['meeting_booking'] == 1) { echo("CHECKED"); } ?> value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights4">Meeting Booking</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights5" id="chkRights5" <?php if($arow['update_profile'] == 1) { echo("CHECKED"); } ?> value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights5">Update Profile</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights6" id="chkRights6" <?php if($arow['change_password'] == 1) { echo("CHECKED"); } ?> value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights6">Update Password</label>
													</td>
												</tr>
												<tr><td height="15"></td></tr>
												<tr>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights7" id="chkRights7" <?php if($arow['support'] == 1) { echo("CHECKED"); } ?> value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights7">Support</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights8" id="chkRights8" <?php if($arow['notification'] == 1) { echo("CHECKED"); } ?> value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights8">Notifications</label>
													</td>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights9" id="chkRights9" <?php if($arow['amenities'] == 1) { echo("CHECKED"); } ?> value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights9">Membership Amenities</label>
													</td>
												</tr>
												<tr><td height="15"></td></tr>
												<tr>
													<td>
														&nbsp;
														<input type="checkbox" name="chkRights10" id="chkRights10" <?php if($arow['amenity_report'] == 1) { echo("CHECKED"); } ?> value="1" class='icheck-me' data-skin="square" data-color="blue">
														<label class='inline' for="chkRights10">Amenity Report</label>
													</td>
												</tr>
												<tr><td height="46"></td></tr>													
											</table>	
											</div>
										</div>
										<!-- /.panel-group -->
									</div>
									<div class="tab-pane" id="second">
										<div class="panel-group panel-widget" id="ac4">
											<div class="panel panel-default">
											<table width="100%">
												<tr>
													<td align="left" valign="top">
													<table width="450" cellpadding="0" cellspacing="0">												
														<tr><td height="15"></td></tr>
														<tr>
															<td>&nbsp;</td>
															<td>
																<label class='inline' for="chkRights1"><b>Conference Rooms</b></label>
															</td>
														</tr>
														<?php
															$slquery1 = $db->prepare("SELECT * FROM slots WHERE sltype = 1 ORDER BY slid ASC");
															$slquery1->execute();
															while($slrow1 = $slquery1->fetch())
															{
																$slid = $slrow1['slid'];
																$arquery = $db->prepare("SELECT aid, conference_room FROM arights WHERE LOCATE($slid, conference_room) > 0 AND aid = ".$_REQUEST['aid']."");
																$arquery->execute();
																$num_conf = $arquery->rowCount();
														?>
														<tr>
															<td>&nbsp;</td>
															<td width="550">
																&nbsp;
																<input type="checkbox" <?php if($num_conf > 0) { echo("CHECKED"); } ?> name="chkConference[]" <?php if($slrow1['slid'] == 8) { echo("checked"); } ?> id="chkConference<?php echo($slrow1['slid']); ?>" value="<?php echo($slrow1['slid']); ?>" class='icheck-me' data-skin="square" data-color="blue">
																<label class='inline' for="chkConference<?php echo($slrow1['slid']); ?>"><?php echo($slrow1['sltitle']); ?></label>
															</td>
														</tr>
														<?php }?>
														<tr><td>&nbsp;</td></tr>
														<tr>
															<td>&nbsp;</td>
															<td>
																<label class='inline' for="chkRights1"><b>Meeting Rooms</b></label>
															</td>
														</tr>
														<?php
															$slquery2 = $db->prepare("SELECT * FROM slots WHERE sltype = 2 ORDER BY slid ASC");
															$slquery2->execute();
															while($slrow2 = $slquery2->fetch())
															{
																$slid = $slrow2['slid'];
																$arquery = $db->prepare("SELECT aid, meeting_room FROM arights WHERE LOCATE($slid, meeting_room) > 0 AND aid = ".$_REQUEST['aid']."");
																$arquery->execute();
																$num_meeting = $arquery->rowCount();
														?>
														<tr>
															<td>&nbsp;</td>
															<td>
																&nbsp;
																<input type="checkbox" <?php if($num_meeting > 0) { echo("CHECKED"); } ?> name="chkMeeting[]" <?php if($slrow2['slid'] == 12) { echo("checked"); } ?> id="chkMeeting<?php echo($slrow2['slid']); ?>" value="<?php echo($slrow2['slid']); ?>" class='icheck-me' data-skin="square" data-color="blue">
																<label class='inline' for="chkMeeting<?php echo($slrow2['slid']); ?>"><?php echo($slrow2['sltitle']); ?></label>
															</td>
														</tr>
														<?php }?>
													</table>	
													</td>
													<td align="left" valign="top">
													
													</td>
												</tr>
											</table>
											</div>
										</div>
									</div>
									<div class="tab-pane" id="third">
										<div class="panel-group panel-widget" id="ac4">
											<div class="panel panel-default">
											<table width="100%">
												<tr>
													<td width="15"></td>
													<td align="left" valign="top">
													<h4>Conference Rooms</h4>
													<table width="950" border="1" class="table-striped">
														<thead>
														<tr class="title" style="background-color: #107E7F;"  bgcolor="#54271D">
															<td width="50" align="center" bgcolor="#107E7F" height="25">&nbsp;<span class="title-font" style="color: white;">Sr No</span></td>
															<td align="left" bgcolor="#107E7F" height="15">&nbsp;<span class="title-font" style="color: white;">Conference Rooms</span></td>
															<td width="75" align="center" bgcolor="green" height="15"><span class="title-font" style="color: white;">Limit</span></td>
															<td width="100" align="center" bgcolor="orange" height="15"><span class="title-font" style="color: white;">Consumed</span></td>
															<td width="100" align="center" bgcolor="red" height="15"><span class="title-font" style="color: white;">Remaining</span></td>
															<td width="100" align="center" bgcolor="brown" height="15"><span class="title-font" style="color: white;">Surplus</span></td>
															<td width="120" align="right" bgcolor="black"><span style="color: white; font-weight: bold;">Payable Charges&nbsp;</span></td>
														</tr>
														</thead>
														<?php
															$count1 = 0;
															$cquery = $db->prepare("SELECT * FROM slots WHERE sltype = ?");
															$cquery->execute(array(1));
															while($crow = $cquery->fetch())
															{
																$count1++;
																$slid = $crow['slid'];
																$sltite = $crow['sltitle'];

																// Check for Limit //

																$subslquery = $db->prepare("SELECT slid,aid, SUM(subsllimit) AS sllimit FROM subslots WHERE aid=? AND slid=?");
																$subslquery->execute(array($_REQUEST['aid'], $slid));
																if($subslquery->rowCount() == 0)
																{															
																	$sllimit = 0;
																}
																else
																{
																	while($subslrow = $subslquery->fetch())
																	{
																		$sllimit = $subslrow['sllimit'];
																	}	
																}

																// Consumed Conference Room Hrs Amenity //

																$amquery = $db->prepare("SELECT aid,slid, SUM(amvalue) AS amconsumed FROM amenity_log WHERE aid=? AND slid=? AND is_charged = ?");
																$amquery->execute(array($_REQUEST['aid'], $slid, 0));
																if($amquery->rowCount() == 0)
																{															
																	$consumend = 0;
																}
																else
																{
																	while($amrow = $amquery->fetch())
																	{
																		$consumed = $amrow['amconsumed'];
																	}	
																}

																if(isset($sllimit)) { $sllimit = $sllimit; } else{ $sllimit = 0; }
																if(isset($consumed)) { $consumed = $consumed; } else{ $consumed = 0; }
																
																if($sllimit > $consumed)
																{
																	$balance = $sllimit - $consumed;
																	$surplus = 0;
																}
																else
																{
																	$balance = 0;
																	$surplus = $consumed - $sllimit;
																}

																if($surplus > 0)
										                        {
										                            $ssquery = $db->prepare("SELECT * FROM subslots WHERE aid=? AND slid=?");
										                            $ssquery->execute(array($_REQUEST['aid'],$slid));
										                            if($ssquery->rowCount() == 0)
										                            {
										                                $extra_charges = "0.00";
										                            }
										                            else
										                            {
										                                while($ssrow = $ssquery->fetch())
										                                {
										                                    $rate = $ssrow['subslrate'];
										                                }

										                                if($rate == 0)
										                                {
										                                    $extra_charges = "0.00";  
										                                }
										                                else
										                                {
										                                    $extra_charges = $surplus * $rate;
										                                }
										                            }
										                        }
										                        else
										                        {
										                            $extra_charges = "0.00";
										                        } 

										                        /// Convert consumed to hrs and mins ///
										                        $consumed_seconds = $consumed * 3600;

											                    $consumed_days = floor($consumed_seconds / 86400);
											                    $consumed_seconds %= 86400;

											                    $consumed_hours = floor($consumed_seconds / 3600);
											                    $consumed_seconds %= 3600;

											                    $consumed_minutes = floor($consumed_seconds / 60);
											                    $consumed_seconds %= 60;
											                      
											                    $time_consumed ="$consumed_hours hrs $consumed_minutes mins";
											                   
											                   	/// Convert balance to hrs and mins ///
										                        $balance_seconds = $balance * 3600;

											                    $balance_hours = floor($balance_seconds / 3600);
											                    $balance_seconds %= 3600;

											                    $balance_minutes = floor($balance_seconds / 60);
											                    $balance_seconds %= 60;
											                      
											                    $time_balance ="$balance_hours hrs $balance_minutes mins";

											                    /// Convert surplus to hrs and mins ///
										                        $surplus_seconds = $surplus * 3600;

											                    $surplus_hours = floor($surplus_seconds / 3600);
											                    $surplus_seconds %= 3600;

											                    $surplus_minutes = floor($surplus_seconds / 60);
											                    $surplus_seconds %= 60;
											                      
											                    $time_surplus ="$surplus_hours hrs $surplus_minutes mins";
														?>
														<tr>
															<td align="center" class="title" height="25"><?php echo($count1); ?></td>
															<td align="left">&nbsp;<?php echo($crow['sltitle']); ?></td>
															<td align="center"><span style="color: green; font-weight: bold; font-size: 12px;"><?php echo($sllimit); ?> hrs</span></td>
															<td align="center"><span style="color: orange; font-weight: bold; font-size: 12px;"><?php if($time_consumed != "0 hrs 0 mins") { echo($time_consumed); } else{echo("0 hrs");} ?></span></td>
															<td align="center"><span style="color: red; font-weight: bold; font-size: 12px;"><?php if($time_consumed != "0 hrs 0 mins") { echo($time_balance); } else{echo("0 hrs");} ?></span></td>
															<td align="center"><span style="color: brown; font-weight: bold; font-size: 12px;"><?php if($time_consumed != "0 hrs 0 mins") { echo($time_surplus); } else{echo("0 hrs");} ?></span></td>
															<td align="right"><span style="color: black; font-weight: bold; font-size: 12px;"><?php echo(number_format($extra_charges,2)); ?></span>&nbsp;</td>
														</tr>
														<?php
															}
														?>
													</table>
													</td>
												</tr>
												<tr><td>&nbsp;</td></tr>

												<tr>
													<td width="15"></td>
													<td align="left" valign="top">
													<h4>Meeting Rooms</h4>
													<table width="950" border="1" class="table-striped">
														<thead>
														<tr class="title" style="background-color: #107E7F;"  bgcolor="#54271D">
															<td width="50" align="center" bgcolor="#107E7F" height="25">&nbsp;<span class="title-font" style="color: white;">Sr No</span></td>
															<td align="left" bgcolor="#107E7F" height="15">&nbsp;<span class="title-font" style="color: white;">Meeting Rooms</span></td>
															<td width="75" align="center" bgcolor="green" height="15"><span class="title-font" style="color: white;">Limit</span></td>
															<td width="100" align="center" bgcolor="orange" height="15"><span class="title-font" style="color: white;">Consumed</span></td>
															<td width="100" align="center" bgcolor="red" height="15"><span class="title-font" style="color: white;">Remaining</span></td>
															<td width="100" align="center" bgcolor="brown" height="15"><span class="title-font" style="color: white;">Surplus</span></td>
															<td width="120" align="right" bgcolor="black"><span style="color: white; font-weight: bold;">Payable Charges</span>&nbsp;</td>
														</tr>
														</thead>
														<?php
															$count1 = 0;
															$cquery = $db->prepare("SELECT * FROM slots WHERE sltype = ?");
															$cquery->execute(array(2));
															while($crow = $cquery->fetch())
															{
																$count1++;
																$slid = $crow['slid'];
																$sltite = $crow['sltitle'];

																// Check for Limit //

																$subslquery = $db->prepare("SELECT slid,aid, SUM(subsllimit) AS sllimit FROM subslots WHERE aid=? AND slid=?");
																$subslquery->execute(array($_REQUEST['aid'], $slid));
																if($subslquery->rowCount() == 0)
																{															
																	$sllimit = 0;
																}
																else
																{
																	while($subslrow = $subslquery->fetch())
																	{
																		$sllimit = $subslrow['sllimit'];
																	}	
																}

																// Consumed Conference Room Hrs Amenity //

																$amquery = $db->prepare("SELECT aid,slid, SUM(amvalue) AS amconsumed FROM amenity_log WHERE aid=? AND slid=? AND is_charged = ?");
																$amquery->execute(array($_REQUEST['aid'], $slid, 0));
																if($amquery->rowCount() == 0)
																{															
																	$consumend = 0;
																}
																else
																{
																	while($amrow = $amquery->fetch())
																	{
																		$consumed = $amrow['amconsumed'];
																	}	
																}

																if(isset($sllimit)) { $sllimit = $sllimit; } else{ $sllimit = 0; }
																if(isset($consumed)) { $consumed = $consumed; } else{ $consumed = 0; }
																
																if($sllimit > $consumed)
																{
																	$balance = $sllimit - $consumed;
																	$surplus = 0;
																}
																else
																{
																	$balance = 0;
																	$surplus = $consumed - $sllimit;
																}

																if($surplus > 0)
										                        {
										                            $ssquery = $db->prepare("SELECT * FROM subslots WHERE aid=? AND slid=?");
										                            $ssquery->execute(array($_REQUEST['aid'],$slid));
										                            if($ssquery->rowCount() == 0)
										                            {
										                                $extra_charges = "0.00";
										                            }
										                            else
										                            {
										                                while($ssrow = $ssquery->fetch())
										                                {
										                                    $rate = $ssrow['subslrate'];
										                                }

										                                if($rate == 0)
										                                {
										                                    $extra_charges = "0.00";  
										                                }
										                                else
										                                {
										                                    $extra_charges = $surplus * $rate;
										                                }
										                            }
										                        }
										                        else
										                        {
										                            $extra_charges = "0.00";
										                        } 

										                        /// Convert consumed to hrs and mins ///
										                        $consumed_seconds = $consumed * 3600;

											                    $consumed_days = floor($consumed_seconds / 86400);
											                    $consumed_seconds %= 86400;

											                    $consumed_hours = floor($consumed_seconds / 3600);
											                    $consumed_seconds %= 3600;

											                    $consumed_minutes = floor($consumed_seconds / 60);
											                    $consumed_seconds %= 60;
											                      
											                    $time_consumed ="$consumed_hours hrs $consumed_minutes mins";
											                   
											                   	/// Convert balance to hrs and mins ///
										                        $balance_seconds = $balance * 3600;

											                    $balance_hours = floor($balance_seconds / 3600);
											                    $balance_seconds %= 3600;

											                    $balance_minutes = floor($balance_seconds / 60);
											                    $balance_seconds %= 60;
											                      
											                    $time_balance ="$balance_hours hrs $balance_minutes mins";

											                    /// Convert surplus to hrs and mins ///
										                        $surplus_seconds = $surplus * 3600;

											                    $surplus_hours = floor($surplus_seconds / 3600);
											                    $surplus_seconds %= 3600;

											                    $surplus_minutes = floor($surplus_seconds / 60);
											                    $surplus_seconds %= 60;
											                      
											                    $time_surplus ="$surplus_hours hrs $surplus_minutes mins";
														?>
														<tr>
															<td align="center" class="title" height="25"><?php echo($count1); ?></td>
															<td align="left">&nbsp;<?php echo($crow['sltitle']); ?></td>
															<td align="center"><span style="color: green; font-weight: bold; font-size: 12px;"><?php echo($sllimit); ?> hrs</span></td>
															<td align="center"><span style="color: orange; font-weight: bold; font-size: 12px;"><?php if($time_consumed != "0 hrs 0 mins") { echo($time_consumed); } else{echo("0 hrs");} ?></span></td>
															<td align="center"><span style="color: red; font-weight: bold; font-size: 12px;"><?php if($time_balance != "0 hrs 0 mins") { echo($time_balance); } else{echo("0 hrs");} ?></span></td>
															<td align="center"><span style="color: brown; font-weight: bold; font-size: 12px;"><?php if($time_surplus != "0 hrs 0 mins") { echo($time_surplus); } else{echo("0 hrs");} ?></span></td>
															<td align="right"><span style="color: black; font-weight: bold; font-size: 12px;"><?php echo(number_format($extra_charges,2)); ?></span>&nbsp;</td>
														</tr>
														<?php
															}
														?>
													</table>
													</td>
												</tr>
												<tr><td>&nbsp;</td></tr>

												<tr>
													<td width="15"></td>
													<td align="left" valign="top">
													<h4>Other Amenities</h4>
													<table width="950" border="1" class="table-striped">
														<thead>
														<tr class="title" style="background-color: #107E7F;"  bgcolor="#54271D">
															<td width="50" align="center" bgcolor="#107E7F" height="25">&nbsp;<span class="title-font" style="color: white;">Sr No</span></td>
															<td align="left" bgcolor="#107E7F" height="15">&nbsp;<span class="title-font" style="color: white;">Amenities</span></td>
															<td width="75" align="center" bgcolor="green" height="15"><span class="title-font" style="color: white;">Limit</span></td>
															<td width="100" align="center" bgcolor="orange" height="15"><span class="title-font" style="color: white;">Consumed</span></td>
															<td width="100" align="center" bgcolor="red" height="15"><span class="title-font" style="color: white;">Remaining</span></td>
															<td width="100" align="center" bgcolor="brown" height="15"><span class="title-font" style="color: white;">Surplus</span></td>
															<td width="120" align="right" bgcolor="black"><span style="color: white; font-weight: bold;">Payable Charges</span>&nbsp;</td>
														</tr>
														</thead>
														<?php
																// Limit for Other Amenities //
																$subquery = $db->prepare("SELECT subid,SUM(printlimit) AS print_limit,printrate,SUM(generatorlimit) AS generator_limit,generatorrate,SUM(electricitylimit) AS electricity_limit,electricityrate,SUM(gaslimit) AS gas_limit,gasrate,SUM(cardlimit) AS card_limit,cardrate,SUM(cardlostlimit) AS card_lost_limit,cardlostrate FROM subscriptions WHERE aid=? AND subarchived=? AND substatus = ?");
																$subquery->execute(array($_REQUEST['aid'], 0, 0));
																if($subquery->rowCount() == 0)
																{
																	$print_limit 	   = 0;
																	$generator_limit   = 0;
																	$electricity_limit = 0;
																	$gas_limit		   = 0;
																	$card_limit		   = 0;
																	$card_lost_limit   = 0;
																	
																	$print_rate        = 0;
											                        $generator_rate    = 0;
											                        $electricity_rate  = 0;
											                        $gas_rate          = 0;
																	$card_rate         = 0;
																	$card_lost_rate    = 0;
																}
																else
																{
																	while($subrow = $subquery->fetch())
																	{
																		$print_limit 	   = $subrow['print_limit'];
																		$generator_limit   = $subrow['generator_limit'];
																		$electricity_limit = $subrow['electricity_limit'];
																		$gas_limit		   = $subrow['gas_limit'];
																		$card_limit		   = $subrow['card_limit'];
																		$card_lost_limit   = $subrow['card_lost_limit'];

																		$print_rate        = $subrow['printrate'];
												                        $generator_rate    = $subrow['generatorrate'];
												                        $electricity_rate  = $subrow['electricityrate'];
												                        $gas_rate          = $subrow['gasrate'];
												                        $card_rate         = $subrow['cardrate'];
												                        $card_lost_rate    = $subrow['cardlostrate'];
																	}
																}

																// Consumed Paper Printing Amenity //
																$amprquery = $db->prepare("SELECT subid,slid,amtype, SUM(amvalue) AS print_consumed FROM amenity_log WHERE aid=? AND slid=? AND amtype = ? AND is_charged = ?");
																$amprquery->execute(array($_REQUEST['aid'],0,1,0));
																if($amprquery->rowCount() == 0)
																{
																	$print_consumed = 0;
																}
																else
																{
																	while($amprrow = $amprquery->fetch())
																	{
																		$print_consumed = $amprrow['print_consumed'];
																	}	
																}

																// Generator Amenity //
																$amgequery = $db->prepare("SELECT subid,slid,amtype, SUM(amvalue) AS generator_consumed FROM amenity_log WHERE aid=? AND slid=? AND amtype = ? AND is_charged = ?");
																$amgequery->execute(array($_REQUEST['aid'],0,4,0));
																if($amgequery->rowCount() == 0)
																{
																	$generator_consumed = 0;
																}
																else
																{
																	while($amgerow = $amgequery->fetch())
																	{
																		$generator_consumed = $amgerow['generator_consumed'];
																	}
																}

																// Electricity Amenity //
																$amelquery = $db->prepare("SELECT subid,slid,amtype, SUM(amvalue) AS electricity_consumed FROM amenity_log WHERE aid=? AND slid=? AND amtype = ? AND is_charged = ?");
																$amelquery->execute(array($_REQUEST['aid'],0,5,0));
																if($amelquery->rowCount() == 0)
																{
																	$electricity_consumed = 0;
																}
																else
																{
																	while($amelrow = $amelquery->fetch())
																	{
																		$electricity_consumed = $amelrow['electricity_consumed'];
																	}
																}

																// Gas Amenity //
																$amgaquery = $db->prepare("SELECT subid,slid,amtype, SUM(amvalue) AS gas_consumed FROM amenity_log WHERE aid=? AND slid=? AND amtype = ? AND is_charged = ?");
																$amgaquery->execute(array($_REQUEST['aid'],0,6,0));
																if($amgaquery->rowCount() == 0)
																{
																	$gas_consumed = 0;
																}
																else
																{
																	while($amgarow = $amgaquery->fetch())
																	{
																		$gas_consumed = $amgarow['gas_consumed'];
																	}
																}

																// GITMIT Card Replacement Amenity //
																$amcardquery = $db->prepare("SELECT subid,slid,amtype, SUM(amvalue) AS card_consumed FROM amenity_log WHERE aid=? AND slid=? AND amtype = ? AND is_charged = ?");
																$amcardquery->execute(array($_REQUEST['aid'],0,7,0));
																if($amcardquery->rowCount() == 0)
																{
																	$card_consumed = 0;
																}
																else
																{
																	while($amcardrow = $amcardquery->fetch())
																	{
																		$card_consumed = $amcardrow['card_consumed'];
																	}
																}

																// GITMIT Card Lost Amenity //
																$amcardlostquery = $db->prepare("SELECT subid,slid,amtype, SUM(amvalue) AS card_lost_consumed FROM amenity_log WHERE aid=? AND slid=? AND amtype = ? AND is_charged = ?");
																$amcardlostquery->execute(array($_REQUEST['aid'],0,8,0));
																if($amcardlostquery->rowCount() == 0)
																{
																	$card_lost_consumed = 0;
																}
																else
																{
																	while($amcardlostrow = $amcardlostquery->fetch())
																	{
																		$card_lost_consumed = $amcardlostrow['card_lost_consumed'];
																	}
																}

																if(isset($print_consumed)) { $print_consumed = $print_consumed; } else{ $print_consumed=0; }	
																if(isset($generator_consumed)) { $generator_consumed = $generator_consumed; } else{ $generator_consumed=0; }

																if(isset($electricity_consumed)) { $electricity_consumed = $electricity_consumed; } else{ $electricity_consumed=0; }
																if(isset($gas_consumed)) { $gas_consumed = $gas_consumed; } else{ $gas_consumed=0; }
																if(isset($card_consumed)) { $card_consumed = $card_consumed; } else{ $card_consumed=0; }
																if(isset($card_lost_consumed)) { $card_lost_consumed = $card_lost_consumed; } else{ $card_lost_consumed=0; }

																
																if($print_limit > $print_consumed)
											                    {
											                      $print_balance = $print_limit - $print_consumed;
											                      $print_surplus = 0;
											                    }
											                    else
											                    {
											                      $print_balance = 0;
											                      $print_surplus = $print_consumed - $print_limit;
											                    }

											                    if($print_surplus > 0)
											                    {
											                        $print_extra_charges = $print_surplus * $print_rate;
											                    }
											                    else
											                    {
											                      $print_extra_charges = "0.00";
											                    }

											                    if($generator_limit > $generator_consumed)
											                    {
											                      $generator_balance = $generator_limit - $generator_consumed;
											                      $generator_surplus = 0;
											                    }
											                    else
											                    {
											                      $generator_balance = 0;
											                      $generator_surplus = $generator_consumed - $generator_limit;
											                    }

											                    if($generator_surplus > 0)
											                    {
											                        $generator_extra_charges = $generator_surplus * $generator_rate;
											                    }
											                    else
											                    {
											                      $generator_extra_charges = "0.00";
											                    }

											                    if($electricity_limit > $electricity_consumed)
											                    {
											                      $electricity_balance = $electricity_limit - $electricity_consumed;
											                      $electricity_surplus = 0;
											                    }
											                    else
											                    {
											                      $electricity_balance = 0;
											                      $electricity_surplus = $electricity_consumed - $electricity_limit;
											                    }

											                    if($electricity_surplus > 0)
											                    {
											                        $electricity_extra_charges = $electricity_surplus * $electricity_rate;
											                    }
											                    else
											                    {
											                      $electricity_extra_charges = "0.00";
											                    }

											                    if($gas_limit > $gas_consumed)
											                    {
											                      $gas_balance = $gas_limit - $gas_consumed;
											                      $gas_surplus = 0;
											                    }
											                    else
											                    {
											                      $gas_balance = 0;
											                      $gas_surplus = $gas_consumed - $gas_limit;
											                    }

											                    if($gas_surplus > 0)
											                    {
											                        $gas_extra_charges = $gas_surplus * $gas_rate;
											                    }
											                    else
											                    {
											                      $gas_extra_charges = "0.00";
											                    }


											                    if($card_limit > $card_consumed)
											                    {
											                      $card_balance = $card_limit - $card_consumed;
											                      $card_surplus = 0;
											                    }
											                    else
											                    {
											                      $card_balance = 0;
											                      $card_surplus = $card_consumed - $card_limit;
											                    }

											                    if($card_surplus > 0)
											                    {
											                        $card_extra_charges = $card_surplus * $card_rate;
											                    }
											                    else
											                    {
											                      $card_extra_charges = "0.00";
											                    }

											                    if($card_lost_limit > $card_lost_consumed)
											                    {
											                      $card_lost_balance = $card_lost_limit - $card_lost_consumed;
											                      $card_lost_surplus = 0;
											                    }
											                    else
											                    {
											                      $card_lost_balance = 0;
											                      $card_lost_surplus = $card_lost_consumed - $card_lost_limit;
											                    }

											                    if($card_lost_surplus > 0)
											                    {
											                        $card_lost_extra_charges = $card_lost_surplus * $card_lost_rate;
											                    }
											                    else
											                    {
											                      $card_lost_extra_charges = "0.00";
											                    }


														?>
														<tr>
															<td align="center" class="title" height="25">1</td>
															<td align="left">&nbsp;<a href="javascript:void:(0)" onclick="return PrintAmenityReport(<?php echo($_REQUEST['aid']); ?>,0,1);">Paper Printing</a></td>
															<td align="center"><span style="color: green; font-weight: bold;"><?php echo($print_limit); ?></span></td>
															<td align="center"><span style="color: orange; font-weight: bold;"><?php if(is_float($print_consumed) == 1) { echo(number_format($print_consumed,2)); } else{ echo($print_consumed); } ?></span></td>
															<td align="center"><span style="color: red; font-weight: bold;"><?php if(is_float($print_balance) == 1) { echo(number_format($print_balance,2)); } else{ echo($print_balance); } ?></span></td>
															<td align="center"><span style="color: brown; font-weight: bold;"><?php if(is_float($print_surplus) == 1) { echo(number_format($print_surplus,2)); } else{ echo($print_surplus); } ?></span></td>
															<td align="right"><span style="color: black; font-weight: bold;"><?php echo(number_format($print_extra_charges,2)); ?></span>&nbsp;</td>
														</tr>
														<tr>
															<td align="center" class="title" height="25">2</td>
															<td align="left">&nbsp;<a href="javascript:void:(0)" onclick="return PrintAmenityReport(<?php echo($_REQUEST['aid']); ?>,0,4);">Generator</a></td>
															<td align="center"><span style="color: green; font-weight: bold;"><?php echo($generator_limit); ?></span></td>
															<td align="center"><span style="color: orange; font-weight: bold;"><?php if(is_float($generator_consumed) == 1) { echo(number_format($generator_consumed,2)); } else{ echo($generator_consumed); } ?></span></td>
															<td align="center"><span style="color: red; font-weight: bold;"><?php if(is_float($generator_balance) == 1) { echo(number_format($generator_balance,2)); } else{ echo($generator_balance); } ?></span></td>
															<td align="center"><span style="color: brown; font-weight: bold;"><?php if(is_float($generator_surplus) == 1) { echo(number_format($generator_surplus,2)); } else{ echo($generator_surplus); } ?></span></td>
															<td align="right"><span style="color: black; font-weight: bold;"><?php echo(number_format($generator_extra_charges,2)); ?></span>&nbsp;</td>
														</tr>
														<tr>
															<td align="center" class="title" height="25">3</td>
															<td align="left">&nbsp;<a href="javascript:void:(0)" onclick="return PrintAmenityReport(<?php echo($_REQUEST['aid']); ?>,0,5);">Electricity</a></td>
															<td align="center"><span style="color: green; font-weight: bold;"><?php echo($electricity_limit); ?></span></td>
															<td align="center"><span style="color: orange; font-weight: bold;"><?php if(is_float($electricity_consumed) == 1) { echo(number_format($electricity_consumed,2)); } else{ echo($electricity_consumed); } ?></span></td>
															<td align="center"><span style="color: red; font-weight: bold;"><?php if(is_float($electricity_balance) == 1) { echo(number_format($electricity_balance,2)); } else{ echo($electricity_balance); } ?></span></td>
															<td align="center"><span style="color: brown; font-weight: bold;"><?php if(is_float($electricity_surplus) == 1) { echo(number_format($electricity_surplus,2)); } else{ echo($electricity_surplus); } ?></span></td>
															<td align="right"><span style="color: black; font-weight: bold;"><?php echo(number_format($electricity_extra_charges,2)); ?></span>&nbsp;</td>
														</tr>
														<tr>
															<td align="center" class="title" height="25">4</td>
															<td align="left">&nbsp;<a href="javascript:void:(0)" onclick="return PrintAmenityReport(<?php echo($_REQUEST['aid']); ?>,0,6);">Gas</a></td>
															<td align="center"><span style="color: green; font-weight: bold;"><?php echo($gas_limit); ?></span></td>
															<td align="center"><span style="color: orange; font-weight: bold;"><?php if(is_float($gas_consumed) == 1) { echo(number_format($gas_consumed,2)); } else{ echo($gas_consumed); } ?></span></td>
															<td align="center"><span style="color: red; font-weight: bold;"><?php if(is_float($gas_balance) == 1) { echo(number_format($gas_balance,2)); } else{ echo($gas_balance); } ?></span></td>
															<td align="center"><span style="color: brown; font-weight: bold;"><?php if(is_float($gas_surplus) == 1) { echo(number_format($gas_surplus,2)); } else{ echo($gas_surplus); } ?></span></td>
															<td align="right"><span style="color: black; font-weight: bold;"><?php echo(number_format($gas_extra_charges,2)); ?></span>&nbsp;</td>
														</tr>
														<tr>
															<td align="center" class="title" height="25">5</td>
															<td align="left">&nbsp;<a href="javascript:void:(0)" onclick="return PrintAmenityReport(<?php echo($_REQUEST['aid']); ?>,0,7);">GITMIT Card Replacement</a></td>
															<td align="center"><span style="color: green; font-weight: bold;"><?php echo($card_limit); ?></span></td>
															<td align="center"><span style="color: orange; font-weight: bold;"><?php if(is_float($card_consumed) == 1) { echo(number_format($card_consumed,2)); } else{ echo($card_consumed); } ?></span></td>
															<td align="center"><span style="color: red; font-weight: bold;"><?php if(is_float($card_balance) == 1) { echo(number_format($card_balance,2)); } else{ echo($card_balance); } ?></span></td>
															<td align="center"><span style="color: brown; font-weight: bold;"><?php if(is_float($card_surplus) == 1) { echo(number_format($card_surplus,2)); } else{ echo($card_surplus); } ?></span></td>
															<td align="right"><span style="color: black; font-weight: bold;"><?php echo(number_format($card_extra_charges,2)); ?></span>&nbsp;</td>
														</tr>
														<tr>
															<td align="center" class="title" height="25">6</td>
															<td align="left">&nbsp;<a href="javascript:void:(0)" onclick="return PrintAmenityReport(<?php echo($_REQUEST['aid']); ?>,0,8);">GITMIT Card Lost / Not Returned</a></td>
															<td align="center"><span style="color: green; font-weight: bold;"><?php echo($card_lost_limit); ?></span></td>
															<td align="center"><span style="color: orange; font-weight: bold;"><?php if(is_float($card_lost_consumed) == 1) { echo(number_format($card_lost_consumed,2)); } else{ echo($card_lost_consumed); } ?></span></td>
															<td align="center"><span style="color: red; font-weight: bold;"><?php if(is_float($card_lost_balance) == 1) { echo(number_format($card_lost_balance,2)); } else{ echo($card_lost_balance); } ?></span></td>
															<td align="center"><span style="color: brown; font-weight: bold;"><?php if(is_float($card_lost_surplus) == 1) { echo(number_format($card_lost_surplus,2)); } else{ echo($card_lost_surplus); } ?></span></td>
															<td align="right"><span style="color: black; font-weight: bold;"><?php echo(number_format($card_lost_extra_charges,2)); ?></span>&nbsp;</td>
														</tr>
													</table>
													</td>
												</tr>
												<tr><td>&nbsp;</td></tr>
											
											</table>
											</div>
										</div>
									</div>
									<div class="tab-pane" id="fourth">
										<div class="panel-group panel-widget" id="ac4">
											<div class="panel panel-default" style="height: 216px;">
											<table width="100%">
												<tr>
													<td width="15"></td>
													<td align="left" valign="top">
													<h4>Memberships</h4>
													<table width="950" border="1" class="table-striped">
														<thead>
														<tr class="title" style="background-color: #107E7F;"  bgcolor="#54271D">
															<td width="50" align="center" bgcolor="#107E7F" height="25">&nbsp;<span class="title-font" style="color: white;">Sr.</span></td>
															<td align="center" bgcolor="#107E7F" height="15">&nbsp;<span class="title-font" style="color: white;">Memberships</span></td>
															<td width="75" align="center" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">Team</span></td>
															<td width="100" align="center" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">Start Date</span></td>
															<td width="100" align="center" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">End Date</span></td>
															<td width="100" align="right" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">Pakage</span>&nbsp;</td>
														</tr>
														</thead>
														<?php
															$mcount = 0;
															$mquery = $db->prepare("SELECT * FROM subscriptions S INNER JOIN accounts A ON S.aid = A.aid WHERE S.subarchived = ? AND A.aid = ?");
															$mquery->execute(array(0,$Aid));
															while($mrow = $mquery->fetch())
															{														
																$mcount++;
																$subid 		= $mrow['subid'];
																$title 	 	= $mrow['subtitle'];
																
																$subquery = $db->prepare("SELECT * FROM submembers WHERE subid=? AND smarchived = ?");
																$subquery->execute(array($subid,0));
																$nummembers = $subquery->rowCount();

																if($mrow['startdate'] != 0) { $startdate  = date("d/m/Y",$mrow['startdate']); } else{ $startdate  = ""; }
																if($mrow['enddate'] != 0) {$enddate  = date("d/m/Y",$mrow['enddate']); } else{ $enddate = ''; };

																$price 	 	 = $mrow['subunitprice'];
																$customer 	 = $mrow['gtno']." - ".$mrow['aname']." (".$mrow['aemail'].")";
														?>
														<tr>
															<td align="center" class="title" height="25"><?php echo($mcount); ?></td>
															<td align="left">&nbsp;
															<?php if($UserEditMembership == 1){ ?>
																<a href="editsubs.php?subid=<?php echo($subid); ?>"><?php echo($mrow['subgtno']." - ".$title); ?></a>
															<?php }else{ echo($mrow['subgtno']." - ".$title); } ?>
															</td>
															<td align="center"><a href="#" onclick="return PrintSubMembers(<?php echo($subid); ?>);"><?php echo($nummembers); ?></a></td>
															<td align="center"><?php echo($startdate); ?></td>
															<td align="center"><?php echo($enddate); ?></td>
															<td align="right">Rs. <?php echo(number_format($price)); ?>&nbsp;</td>
														</tr>
														<?php
															}
														?>
													</table>
													</td>
												</tr>
											</table>	
											</div>
										</div>
										<!-- /.panel-group -->
									</div>
									<div class="tab-pane" id="fifth">
										<div class="panel-group panel-widget" id="ac4">
											<div class="panel panel-default">
											<table width="100%">
												<tr>
													<td width="15"></td>
													<td align="left" valign="top">
													<h4>Additional Members</h4>
													<table width="950" border="1" class="table-striped">
														<thead>
														<tr class="title" style="background-color: #107E7F;"  bgcolor="#54271D">
															<td width="50" align="center" bgcolor="#107E7F" height="25">&nbsp;<span class="title-font" style="color: white;">Sr.</span></td>
															<td align="center" bgcolor="#107E7F" height="15">&nbsp;<span class="title-font" style="color: white;">Members</span></td>
															<td width="75" align="center" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">Image</span></td>
														</tr>
														</thead>
														<?php
															$smcount = 0;
															$smquery = $db->prepare("SELECT * FROM submembers SM INNER JOIN accounts A ON SM.aid = A.aid INNER JOIN subscriptions S ON SM.subid = S.subid INNER JOIN plans P ON S.plid = P.plid WHERE SM.smname <> '' AND SM.smarchived=? AND SM.aid = ?");
															$smquery->execute(array(0,$Aid));
															while($smrow = $smquery->fetch())
															{
																$smcount++;
																$smid = $smrow['smid'];
																$aid = $smrow['aid'];
																$smgtno = $smrow['smgtno'];
																$gtno = $smrow['gtno'];	

																if($smrow['smimage'] != "")
																{
																	$Image = "../images/members/images/".$smrow['smimage'];
																}
																else
																{
																	$Image = "../images/no_image.png";
																}
														?>
														<tr>
															<td align="center" class="title" height="25"><?php echo($smcount); ?></td>
															<td align="left">&nbsp;
															<?php if($UserEditSubMember == 1){ ?>
															<a href="editsubmember.php?smid=<?php echo($smrow['smid']); ?>"><?php echo($smgtno." - ".$smrow['smname']); ?> - <?php echo($smrow['smemail']); ?></a>
															<?php }else{ echo($smgtno." - ".$smrow['smname']); ?> - <?php echo($smrow['smemail']); } ?>
															</td>
															<td align="center"><img src="<?php echo($Image); ?>" width="50"></td>
														</tr>
														<?php
															}
														?>

													</table>
													</td>
												</tr>
												<tr><td><br><br><br></td></tr>
												<tr><td><br><br><br><br></td></tr>

											</table>	
											</div>
										</div>
										<!-- /.panel-group -->
									</div>
									<div class="tab-pane" id="sixth">
										<div class="panel-group panel-widget" id="ac4">
											<div class="panel panel-default">
											<table width="100%">
												<tr>
													<td width="15"></td>
													<td align="left" valign="top">
													<h4>Sale Invoices</h4>
													<table width="950" border="1" class="table-striped">
														<thead>
														<tr class="title" style="background-color: #107E7F;"  bgcolor="#54271D">
															<td width="50" align="center" bgcolor="#107E7F" height="25">&nbsp;<span class="title-font" style="color: white;">Sr.</span></td>
															<td align="left" bgcolor="#107E7F" height="15">&nbsp;<span class="title-font" style="color: white;">Invoice#</span></td>
															<td width="100" align="center" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">Date</span></td>
															<td width="100" align="right" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">Total</span>&nbsp;</td>
															<td width="100" align="center" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">Status</span></td>
															<td width="75" align="center" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">.</span></td>
														</tr>
														</thead>
														<?php
															$icount = 0;
														//	echo("SELECT * FROM invoices I INNER JOIN accounts A ON I.aid = A.aid WHERE I.subid = 0 AND A.acarchived = 0 AND A.aid = $Aid ORDER BY I.invid DESC");
															$iquery = $db->prepare("SELECT * FROM invoices I INNER JOIN accounts A ON I.aid = A.aid WHERE I.subid = 0 AND A.acarchived = 0 AND A.aid = $Aid ORDER BY I.invid DESC");
															$iquery->execute();
															while($irow = $iquery->fetch())
															{
																$icount++;
														?>
														<tr>
															<td align="center" class="title" height="25"><?php echo($icount); ?></td>
															<td align="left">&nbsp;
																<a href="view_invoice.php?invid=<?php echo($irow['invid']); ?>" target="_blank">INV-<?php echo($irow['invid']); ?>  (<?php echo($irow['gtno']); ?>-<?php echo($irow['aname']); ?> - <?php echo($irow['aemail']); ?>)</a>
															</td>
															<td width="100" align="center" class='hidden-350'><?php echo(date("d/m/Y",$irow['invdate'])); ?></td>
															<td width="100" align="right" class='hidden-350'>PKR <?php echo(number_format($irow['totalamount'])); ?>&nbsp;</td>
															<td width="100" align="center" class='hidden-350'>
																<?php if($irow['invstatus'] == 1){ ?>
																<span style="color: green;">Paid</span>
																<?php }else{ ?>
																<span style="color: red;">Unpaid</span>
																<?php } ?>
															</td>
															<td align="center" width="75" class='hidden-480'>
																<a href="#" class="btn" rel="tooltip" title="Print" onclick="return PrintInvoice(<?php echo($irow['invid']); ?>);">
																	<i class="fa fa-file"></i>
																</a>
																<a href="view_invoice.php?invid=<?php echo($irow['invid']); ?>" target="_blank" class="btn" rel="tooltip" title="Edit">
																	<i class="fa fa-edit"></i>
																</a>
															</td>
														</tr>
														<?php
															}
														?>

													</table>
													</td>
												</tr>
												<tr><td height="118">&nbsp;</td></tr>
											</table>	
											</div>
										</div>
										<!-- /.panel-group -->
									</div>
									<div class="tab-pane" id="seventh">
										<div class="panel-group panel-widget" id="ac4">
											<div class="panel panel-default">
											<table width="100%">
												<tr>
													<td width="15"></td>
													<td align="left" valign="top">
													<h4>Transactions</h4>
													<table width="950" border="1" class="table-striped">
														<thead>
														<tr class="title" style="background-color: #107E7F;"  bgcolor="#54271D">
															<td width="50" align="center" bgcolor="#107E7F" height="25">&nbsp;<span class="title-font" style="color: white;">Sr.</span></td>
															<td width="100" align="center" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">Date</span></td>
															<td align="left" bgcolor="#107E7F" height="15">&nbsp;<span class="title-font" style="color: white;">Details</span></td>
															<td width="100" align="right" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">Debit</span>&nbsp;</td>
															<td width="100" align="right" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">Credit</span>&nbsp;</td>
															<td width="100" align="right" bgcolor="#107E7F" height="15"><span class="title-font" style="color: white;">Balance</span>&nbsp;</td>
														</tr>
														</thead>
														<?php
															$lcount = 0;
															$lequery = $db->prepare("SELECT * FROM ledger WHERE aid = $Aid ORDER BY leid DESC");
															$lequery->execute();
															while($lerow = $lequery->fetch())
															{
																$lcount++;
																if($lerow['debit'] != 0 && $lerow['credit'] != 0) {  $bgcolor = "#FFF"; }
																if($lerow['debit'] != 0 && $lerow['credit'] == 0) {  $bgcolor = "#FCEBEB"; }
																if($lerow['debit'] == 0 && $lerow['credit'] != 0) {  $bgcolor = "#EDFCEB"; }
														?>
														<tr bgcolor="<?php echo($bgcolor); ?>">
															<td align="center" class="title" height="25"><?php echo($lcount); ?></td>
															<td align="left"><?php echo(date("d/m/Y",$lerow['ldate'])); ?></td>
															<td align="left" class='hidden-350'>&nbsp;<?php echo($lerow['detail']); ?></td>
															<td width="100" align="right" class='hidden-350'><?php echo(number_format($lerow['debit'])); ?>&nbsp;</td>
															<td width="100" align="right" class='hidden-350'><?php echo(number_format($lerow['credit'])); ?>&nbsp;</td>
															<td width="100" align="right" class='hidden-350'><?php echo(number_format($lerow['balance'])); ?>&nbsp;</td>
														</tr>
														<?php
															}
														?>
														<tr>
														<?php
																$totalquery = $db->prepare("SELECT SUM(debit) AS totalreceived, SUM(credit) AS totalpayment FROM ledger WHERE aid = $Aid");
																$totalquery->execute();
																while($totalrow = $totalquery->fetch())
																{
														?>
															<td style="border: 1px solid #000;" align="right" height="35" colspan="3"></td>
															<td style="border: 1px solid #000;" align="right"><b><?php echo(number_format($totalrow['totalreceived'])); ?></b>&nbsp;</td>
															<td style="border: 1px solid #000;" align="right"><b><?php echo(number_format($totalrow['totalpayment'])); ?></b>&nbsp;</td>
														
														<?php
																}
																$balQuery = $db->prepare("SELECT balance FROM ledger WHERE aid = $Aid ORDER BY leid DESC LIMIT 0,1");
																$balQuery->execute();
																while($balrow = $balQuery->fetch())
																{
																	$CurrentBalance = $balrow['balance'];
														?>
															<td style="border: 1px solid #000;" align="right"><b><?php echo(number_format($CurrentBalance)); ?></b>&nbsp;</td>
														<?php
																}
														?>
														</tr>
													</table>
													</td>
												</tr>
												<tr><td height="88">&nbsp;</td></tr>

											</table>	
											</div>
										</div>
										<!-- /.panel-group -->
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php } } ?>
				<div class="form-actions">
					<input name="btnSubmit" type="submit" class="btn btn-primary" value="  Update Customer  ">
					<?php if($row['acarchived'] == 0 && $UserEmailCustomer == 1){ ?>
					<?php if($row['passdate'] == 0){ ?><input name="btnSend" type="button" class="btn btn-danger" value="  Send Customer Login Details  " onclick="return SendLogin(<?php echo($_REQUEST['aid']); ?>)"><?php } else{ ?>
					<input name="btnReset" type="button" class="btn btn-success" value="  Reset Customer Password  " onclick="return ResetPassword(<?php echo($_REQUEST['aid']); ?>)"><?php } ?>
					<?php } ?>
					<button type="button" class="btn">Cancel</button>
				</div>
				</form>
			<?php } ?>
			</div>
		</div>
	</div>
</body>
</html>