<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	/////////// Function to Create Pending Invoices On Every 1st of the Month 3:00 AM /////////
	
	$Date = time();
	$subquery = $db->prepare("SELECT * FROM subscriptions WHERE subid = ?");
	$subquery->execute(array(2));
	while($subrow = $subquery->fetch())
	{
		$aid   = $subrow['aid'];
		$subid 	= $subrow['subid'];

		$smquery = $db->prepare("SELECT * FROM submembers WHERE smname <> '' AND smarchived = 0 AND smstatus = 0 AND subid=$subid");
		$smquery->execute();
		$num_members = $smquery->rowCount(); // Note: All Addtional Members whos name are entered and there status and archived status is active will be counted in the invoice 

		$unitprice = $subrow['subunitprice'];
		
		$totalprice = $num_members * $unitprice;
		
		$printrate 	 	 = $subrow['printrate'];
		$meetingrate 	 = $subrow['meetingrate'];
		$conferencerate  = $subrow['conferencerate'];
		$generatorrate   = $subrow['generatorrate'];

		$printlimit 	 = $subrow['printlimit'];
		$meetinglimit 	 = $subrow['meetinglimit'];
		$conferencelimit = $subrow['conferencelimit'];
		$generatorlimit  = $subrow['generatorlimit'];

		$num_print 	 	 = $subrow['num_print'];
		$num_meeting 	 = $subrow['num_meeting'];
		$num_conference  = $subrow['num_conference'];
		$num_generator 	 = $subrow['num_generator'];

		$print_comsumed 	 = $num_print - $printlimit;
		$meeting_comsumed 	 = $num_meeting - $meetinglimit;
		$conference_comsumed = $num_conference - $conferencelimit;
		$generator_comsumed  = $num_generator - $generatorlimit;

		if($print_comsumed 		> 0) { $inv_print_price 	 = $print_comsumed * $printrate; 	  	   $pinvoice_print	    = "Extra Paper Printing Charges $printrate x $print_comsumed = $inv_print_price"; } 			 		  else{ $inv_print_price 	  = 0; $pinvoice_print 	    = ""; }
		if($meeting_comsumed 	> 0) { $inv_meeting_price 	 = $meeting_comsumed * $meetingrate;  	   $pinvoice_meeting    = "Extra Meeting Room Hours Charges $meetingrate x $meeting_comsumed = $inv_meeting_price"; } 			  else{ $inv_meeting_price 	  = 0; $pinvoice_meeting    = ""; }
		if($conference_comsumed > 0) { $inv_conference_price = $conference_comsumed * $conferencerate; $pinvoice_conference = "Extra Conference Room Hours Charges $conferencerate x $conference_comsumed = $inv_conference_price"; } else{ $inv_conference_price = 0; $pinvoice_conference = ""; }
		if($generator_comsumed 	> 0) { $inv_generator_price	 = $generator_comsumed * $generatorrate;   $pinvoice_generator	= "Extra Generator Charges $generatorrate x $generator_comsumed = $inv_generator_price"; } 				  else{ $inv_generator_price  = 0; $pinvoice_generator  = ""; }

		//// Amenity Calculation
		
		$total_invoice_amount = $totalprice + $inv_print_price + $inv_meeting_price + $inv_conference_price + $inv_generator_price;
		
		$remarks = "Membership Invoice for the Month of ".date("F Y")."";
		
		echo("Total Members: $num_members | Unit Price: $unitprice | Total: $num_members x $unitprice = $totalprice <br>
			Print: $num_print - $printlimit : $print_comsumed  | $pinvoice_print<br>
			Meeting: $num_meeting - $meetinglimit : $meeting_comsumed | $pinvoice_meeting<br>
			Conference: $num_conference - $conferencelimit : $conference_comsumed | $pinvoice_conference<br>
			Generator: $num_generator - $generatorlimit : $generator_comsumed | $pinvoice_generator <br><br>
			Total Invoice Amount: $total_invoice_amount");
	//	die;
		
	}

	/// Start Invoice ///
	
	$invquery = $db->prepare("INSERT INTO pending_invoices(aid, subid, remarks, totalamount, pinvdate) VALUES(?,?,?,?,?)");
	$inv_values = array($aid,$subid,$remarks,$total_invoice_amount,$Date);
	if($invquery->execute($inv_values))
	{
		$pinvid = $db->lastInsertId();
		
		$invdquery1 = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
		$invdvalues1 = array($pinvid,'Monthly Membership Charges',$unitprice,$num_members,$totalprice,$Date);
		$invdquery1->execute($invdvalues1);

		if($print_comsumed > 0)
		{
			$invdquery2 = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
			$invdvalues2 = array($pinvid,$pinvoice_print,$printrate,$print_comsumed,$inv_print_price,$Date);
			$invdquery2->execute($invdvalues2);
		}

		if($meeting_comsumed > 0)
		{
			$invdquery3 = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
			$invdvalues3 = array($pinvid,$pinvoice_meeting,$meetingrate,$meeting_comsumed,$inv_meeting_price,$Date);
			$invdquery3->execute($invdvalues3);
		}

		if($conference_comsumed > 0)
		{
			$invdquery4 = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
			$invdvalues4 = array($pinvid,$pinvoice_conference,$conferencerate,$conference_comsumed,$inv_conference_price,$Date);
			$invdquery4->execute($invdvalues4);
		}

		if($generator_comsumed 	> 0)
		{
			$invdquery5 = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
			$invdvalues5 = array($pinvid,$pinvoice_generator,$generatorrate,$generator_comsumed,$inv_generator_price,$Date);
			$invdquery5->execute($invdvalues5);
		}
	}
	header("Location: pending_invoices.php?");
?>