<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();
	chk_booking_amenity($db,$URL);
	if($UserConferenceLog == 0) { header("Location: main.php"); }
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Conference Bookings</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script language="javascript" type="text/javascript">
		function DeleteBooking(bid)
		{
			var cd;
			cd = confirm("Are you sure to delete?");
			if(cd)
			{
				window.location.href = "delete_booking.php?btype=1&bid="+bid;
			}
		}
	</script>
	<!--[if lte IE 9]>
	<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
	<script>
		$(document).ready(function () {
			$('input, textarea').placeholder();
		});
	</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<!-- HEADER START -->
<?php include("top.php"); ?>
<!-- HEADER END -->
<div class="container-fluid" id="content">
<div id="left">
	<form action="search-results.php" method="GET" class='search-form'>
		<div class="search-pane">
			<input type="text" name="search" placeholder="Search here...">
			<button type="submit">
				<i class="fa fa-search"></i>
			</button>
		</div>
	</form>
	<!-- QUICK LINKS -->
	<?php include("left.php"); ?>
	<!-- QUICK LINKS -->
</div>
<div id="main">
<div class="container-fluid">
<div class="page-header">
	<div class="pull-left">
		<h1><i class="glyphicon-calendar"></i> Conference Bookings</h1>
	</div>
	<div class="pull-right">
	</div>
</div>
<div class="breadcrumbs">
	<ul>
		<li>
			<a href="main.php">Home</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="conference_log.php">Conference Bookings</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<?php if($UserAddConferenceLog == 1) { ?>
		<li>
			<a href="addconference_log.php">Create Conference Booking</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<?php } ?>
	</ul>
	<div class="close-bread">
		<a href="#">
			<i class="fa fa-times"></i>
		</a>
	</div>
</div>
<?php
	if(isset($_REQUEST['err']))
	{
?>
<div class="alert alert-success alert-dismissable">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<?php echo($ErrMsg); ?>
</div>
<?php
	}
?>	
<div class="row">
	<div class="col-sm-12">
		<div class="box box-color box-bordered">
			<div class="box-title">
				<h3>Conference Bookings</h3>
			</div>
			<div class="box-content nopadding hscroll">
				<table class="table table-hover table-nomargin table-bordered dataTable">
					<thead>
					<tr>
						<th>Sr #</th>
						<th>Customer</th>
						<th>Title</th>
						<th>Room</th>
						<th>Date</th>
						<th align="center" class='hidden-350'>From</th>
						<th align="center" class='hidden-350'>To</th>
						<th align="center" class='hidden-350'>Total</th>
						<th align="center" class='hidden-350'>Status</th>
						<th class='hidden-480'>.</th>
					</tr>
					</thead>
					<tbody>
					<?php
						$Count = 0;
						$Query = $db->prepare("SELECT * FROM booking B INNER JOIN slots SL ON B.slid = SL.slid INNER JOIN accounts A ON B.aid = A.aid WHERE B.btype = ? ORDER BY B.bid DESC");
						$Query->execute(array(1));
						while($row = $Query->fetch())
						{
							$Count++;
							$bid 		= $row['bid'];
							$aid 		= $row['aid'];
							
							$bdate = date("d-m-Y",$row['bookdate']);
							$from  = date("h:i A",$row['btimefrom']);
							$to    = date("h:i A",$row['btimeto']);

							$customer 	 = $row['gtno']."-".$row['aname']." (".$row['aemail'].")";
					?>
					<tr>
						<td width="10" align="left" class='hidden-350'><?php echo($Count); ?></td>
						<td width="500">
							<a href="viewconference_log.php?bid=<?php echo($bid); ?>"><?php echo($customer); ?></a>
						</td>
						<td align="left" width="550"><a href="viewconference_log.php?bid=<?php echo($bid); ?>"><?php echo($row['btitle']); ?></a></td>
						<td width="300" align="left" class='hidden-350'><?php echo($row['sltitle']); ?></td>
						<td width="150" align="center" class='hidden-350'><?php echo($bdate); ?></td>
						<td width="150" align="center" class='hidden-350'><?php echo($from); ?></td>
						<td width="150" align="center" class='hidden-350'><?php echo($to); ?></td>
						<?php
							$seconds = $row['btimeto'] - $row['btimefrom'];

		                    $days = floor($seconds / 86400);
		                    $seconds %= 86400;

		                    $hours = floor($seconds / 3600);
		                    $seconds %= 3600;

		                    $minutes = floor($seconds / 60);
		                    $seconds %= 60;
		                      
		                    $total_hrs ="$hours Hrs $minutes Mins";
						?>
						<td width="250" align="center" class='hidden-350'><?php echo($total_hrs); ?></td>
						<td width="150" align="center" class='hidden-350'>
							<?php if($row['bstatus'] == 1){ ?>
							<span style="color:red">Expired</span>
							<?php }else{ ?>
							<span style="color:green">Active</span>
							<?php } ?>
						</td>	
						<td width="350" class='hidden-480'>
							<a href="viewconference_log.php?bid=<?php echo($bid); ?>" class="btn" rel="tooltip" title="View">
								<i class="fa fa-file-o"></i>
							</a>
							<?php if($UserEditConferenceLog == 1) { ?>
							<a href="editconference_log.php?bid=<?php echo($bid); ?>" class="btn" rel="tooltip" title="Edit">
								<i class="fa fa-edit"></i>
							</a>
							<?php } if($UserDeleteConferenceLog == 1) { ?>
							<a href="javascript:Void(0);" class="btn" rel="tooltip" title="Delete" onclick="return DeleteBooking(<?php echo($bid); ?>)">
								<i class="fa fa-times"></i>
							</a>
							<?php } ?>
						</td>
					</tr>
					<?php
						}
					?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</body>
</html>