<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Item Barcode</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>


	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Datepicker -->
	<script src="js/plugins/datepicker/bootstrap-datepicker.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script type="text/javascript" src="datepickercontrol.js"></script>
	<script language="JavaScript">
		if (navigator.platform.toString().toLowerCase().indexOf("linux") != -1)
		{ document.write('<link type="text/css" rel="stylesheet" href="datepickercontrol_lnx.css">'); }
		else
		{ document.write('<link type="text/css" rel="stylesheet" href="datepickercontrol.css">'); }
	</script>
	<script src="js/JsBarcode.all.min.js"></script>
	<style type="text/css">
		@media print {
		    tr.title {
		        background-color: #54271D !important;
		        -webkit-print-color-adjust: exact;
		        color: #fff; 
		    }
		}
		@media print {
		    .title td {
		        color: white !important;
		    }
		}


		@media print {
		    tr.footer {
		        background-color: #107E7F !important;
		        -webkit-print-color-adjust: exact;
		        color: #fff; 
		    }
		}
		.title-font{
			color: #fff !important;
			font-weight: bold;
		}


	</style>
	<link type="text/css" rel="stylesheet" href="content.css">
	<!-- Datepicker -->
	<link rel="stylesheet" href="css/plugins/datepicker/datepicker.css">
	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<table width="100%" cellspacing="0" cellpadding="0">
	<?php
		if($_REQUEST['wodid'] > 0){
			$query = $db->prepare("SELECT * FROM workorder W INNER JOIN workorderdetail WD ON W.woid = WD.woid WHERE WD.wodid = ?");
			$query->execute(array($_REQUEST['wodid']));
		}else{
			$query = $db->prepare("SELECT * FROM workorder W INNER JOIN workorderdetail WD ON W.woid = WD.woid WHERE WD.woid = ?");
			$query->execute(array($_REQUEST['woid']));
		}	
		while($row = $query->fetch())
		{
			$woid = $row['woid'];
			$aid = $row['aid'];
			$lid = $row['lid'];
			$uid = $row['uid'];
			$woremarks = $row['woremarks'];
			$woqty = $row['woqty'];
			$comqty = $row['comqty'];

			$startdate = date("d/m/Y",$row['startdate']);

			if($row['completedate'] > 0) { $enddate = date("d/m/Y",$row['completedate']); } else{ $enddate = ""; }
			if($row['wostatus'] == 0) { $wostatus = "In Progress"; } else{ $wostatus = "Completed"; }
			
			if($_REQUEST['wodid'] > 0){
				$bcquery = $db->prepare("SELECT * FROM product_barcodes WHERE szid = ? AND wodid = ?");
				$bcquery->execute(array($_REQUEST['szid'],$_REQUEST['wodid']));
			}
			else
			{
				$bcquery = $db->prepare("SELECT * FROM product_barcodes WHERE woid = ?");
				$bcquery->execute(array($_REQUEST['woid']));	
			}
			$numBarCode = $bcquery->rowCount();
			$message = "";
			if(isset($_REQUEST['err'])) { if($_REQUEST['err'] == 19) { $message = "<span style='color:red;'>$ErrMsg</span>"; } }
			$count = 0;
										
			if($numBarCode > 0)
			{
				while($bcrow = $bcquery->fetch())
				{
					$count++;
	?>
	<tr>
		<td align="center">
			<svg id="barcode<?php echo($count); ?>"></svg>
			<script type="text/javascript">
				JsBarcode("#barcode<?php echo($count); ?>", "<?php echo($bcrow['barcode']); ?>", {width: 1,height: 50,fontSize: 15,marginTop: 25,displayValue: true});
			</script>
		</td>
	</tr>
	<?php } } } ?>
</table>	
</body>
</html>