<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login($db,$URL);
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Assignments</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<!-- <script language="javascript" type="text/javascript">
		function DeleteRecipe(reid)
		{
			var cd;
			cd = confirm("Are you sure to delete?");
			if(cd)
			{
				window.location.href = "delete_recipe.php?reid="+reid;
			}
		}
	</script> -->
	<!--[if lte IE 9]>
	<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
	<script>
		$(document).ready(function () {
			$('input, textarea').placeholder();
		});
	</script>
	<![endif]-->
	<script language="javascript" type="text/javascript">
		function DeleteAssignment(asid)
		{
			var cd;
			cd = confirm("Are you sure to delete?");
			if(cd)
			{
				window.location.href = "delete_assignment.php?asid="+asid;
			}
		}

		function print_profile(id)
		{
			window.open( "print_assignment_record.php?id="+id+"", "myWindow", "status = 1, scrollbars=1, height = 1000, WIDTH= 1600, resizable = 1, top = 0" )
		}

		function redirect(type)
		{
			if(type == 1){
				window.location.href = "assignments.php?a=all";		
			}
			else{
				window.location.href = "assignments.php?a=active";
			}
		}
	</script>
	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<!-- HEADER START -->
<?php include("top.php"); ?>
<!-- HEADER END -->
<div class="container-fluid" id="content">
<div id="left">
	<form action="search-results.php" method="GET" class='search-form'>
		<div class="search-pane">
			<input type="text" name="search" placeholder="Search here...">
			<button type="submit">
				<i class="fa fa-search"></i>
			</button>
		</div>
	</form>
	<!-- QUICK LINKS -->
	<?php include("left.php"); ?>
	<!-- QUICK LINKS -->
</div>
<div id="main">
<div class="container-fluid">
<div class="page-header">
	<div class="pull-left">
		<h1><i class="fa fa-table"></i> Manage Assignments</h1>
	</div>
	<div class="pull-right">
	</div>
</div>
<div class="breadcrumbs">
	<ul>
		<li>
			<a href="main.php">Home</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="assignments.php">Assignments</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="addassignment.php?">Create New Assignment</a>
		</li>
	</ul>
	<div class="close-bread">
		<a href="#">
			<i class="fa fa-times"></i>
		</a>
	</div>
</div>
<?php
	if(isset($_REQUEST['err']))
	{
?>
<div class="alert alert-success alert-dismissable">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<?php echo($ErrMsg); ?>
</div>
<?php
	}
	if(isset($_REQUEST['a']))
	{
		if($_REQUEST['a'] == "all"){
			$all_assigment = "WHERE A.asstatus = 0";
			$btn_title = "Show Active";	
			$btn_type = 2;	
		}
		if($_REQUEST['a'] == "active")
		{
			$all_assigment = "WHERE A.asstatus = 0";
			$btn_title = "Show All";	
			$btn_type = 1;
		}
		
	}
	else
	{
		$all_assigment = "WHERE A.asstatus = 0";
		$btn_title = "Show Active";
		$btn_type = 2;
	}
?>	
<div class="row">
	<div class="col-sm-12">
		<div class="box box-color box-bordered">
			<div class="box-title">
				<table width="100%">
					<tr>
						<td align="left"><h3>Manage Assignments</h3></td>
						<td align="right"><input type="button" class="btn btn-success" value="<?php echo($btn_title); ?>" onclick="return redirect(<?php echo($btn_type); ?>);"></td>
					</tr>
				</table>
				
			</div>
			<div class="box-content nopadding hscroll">
				<table class="table table-hover table-nomargin table-bordered dataTable">
					<thead>
					<tr>
						<th>Sr.</th>
						<th>Store</th>
						<th>City</th>
						<th>BA</th>	
						<th>Brand</th>
						<th>Supervisor</th>
						<th>Shift</th>
						<th>Status</th>
						<th class='hidden-480'>Options</th>
					</tr>
					</thead>
					<tbody>
					<?php
						$count = 0;

						$Query = $db->prepare("SELECT * FROM assignments A INNER JOIN brand B ON A.brid = B.brid 
							INNER JOIN store S ON A.stid = S.stid $all_assigment ORDER BY S.store_name ASC");
						$Query->execute();
						while($row = $Query->fetch())
						{
							$count++;
							$asid 		 = $row['asid'];
							$brname 		 = $row['brname'];
							$uid = $row['uid'];
							$supuid = $row['supuid'];

							$store_name = $row['store_name'];
							$store_code 	= $row['store_code'];
							$store_city = $row['city'];

							$asstarttime = $row['asstarttime'];
							$asofftime = $row['asofftime'];

							// BA
							if($uid != 0)
							{
								$baquery = $db->prepare("SELECT uid, ba_no, fullname, username, city FROM users WHERE uid = ?");
								$baquery->execute(array($uid));
								if($baquery->rowCount() == 0)
								{
									$ba_name = "Undefined";
									$ba_username = "Undefined";
								}
								while($barow = $baquery->fetch())
								{
									$ba_no = $barow['ba_no'];
									$ba_name = $barow['fullname'];
									$ba_city = $barow['city'];
									$ba_username = $barow['username'];	
								}
							}
							
							
							// Supervisor
							$supquery = $db->prepare("SELECT uid, fullname, username FROM users WHERE uid = ?");
							$supquery->execute(array($supuid));
							while($suprow = $supquery->fetch())
							{
								$sup_name = $suprow['fullname'];
								$sup_username = $suprow['username'];	
							}

							// SKU's
							$asdquery = $db->prepare("SELECT asdid, asid, pid, asdstatus FROM assignment_detail WHERE asid = ?");
							$asdquery->execute(array($asid));
							$num_skus = $asdquery->rowcount();
					?>
					
					<tr>
						<td width="50"><?php echo($count); ?></td>
						<td>
							<a href="#"  onclick="return print_profile(<?php echo($row['asid']); ?>);"><?php echo($store_name); ?> - ST-<?php echo($store_code); ?></a>
							
						</td>
						<td><?php echo($store_city); ?></td>
						<td>
							<?php if($uid != 0 ){ echo($ba_name); ?>, <?php echo($ba_city); ?> (<?php echo($ba_username); ?>): BA-<?php echo($ba_no); } else{ echo("Undefined"); } ?></td>
						<td><?php echo($brname); ?></td>
						<td><?php echo($sup_name); ?></td>
						
						<td><?php echo($asstarttime); ?> To <?php echo($asofftime); ?></td>
						
						<td><?php if($row['asstatus'] == 0){ ?><span style="color:green;">Active</span><?php }else{ ?><span style="color:red;">Inactive</span><?php } ?></td>
						<td width="120" class='hidden-480'>
							<?php if($uid != 0){ ?>
							<a href="unassign_ba.php?asid=<?php echo($asid); ?>" class="btn" rel="tooltip" title="Un-Assign">
								<i class="fa fa-chain-broken"></i>
							</a>
							<?php } ?>
							<a href="editassignment.php?asid=<?php echo($asid); ?>" class="btn" rel="tooltip" title="Edit">
								<i class="fa fa-edit"></i>
							</a>
							<a href="javascript:Void(0);" disabled class="btn" rel="tooltip" title="Delete" onclick="return DeleteAssignment(<?php echo($asid); ?>)">
								<i class="fa fa-times"></i>
							</a>
						</td>
					</tr>
					<?php
						}

						if(isset($_REQUEST['a']))
						{
							if($_REQUEST['a'] == "all")
							{
								$Query = $db->prepare("SELECT * FROM assignments A INNER JOIN brand B ON A.brid = B.brid 
									INNER JOIN store S ON A.stid = S.stid WHERE A.asstatus = 1 ORDER BY S.store_name ASC");
								$Query->execute();
								while($row = $Query->fetch())
								{
									$count++;
									$asid 		 = $row['asid'];
									$brname 		 = $row['brname'];
									$uid = $row['uid'];
									$supuid = $row['supuid'];

									$store_name = $row['store_name'];
									$store_code 	= $row['store_code'];
									$store_city = $row['city'];

									$asstarttime = $row['asstarttime'];
									$asofftime = $row['asofftime'];

									// BA
									if($uid != 0)
									{
										$baquery = $db->prepare("SELECT uid, ba_no, fullname, username, city FROM users WHERE uid = ?");
										$baquery->execute(array($uid));
										if($baquery->rowCount() == 0)
										{
											$ba_name = "Undefined";
											$ba_username = "Undefined";
										}
										while($barow = $baquery->fetch())
										{
											$ba_no = $barow['ba_no'];
											$ba_name = $barow['fullname'];
											$ba_city = $barow['city'];
											$ba_username = $barow['username'];	
										}
									}
									
									
									// Supervisor
									$supquery = $db->prepare("SELECT uid, fullname, username FROM users WHERE uid = ?");
									$supquery->execute(array($supuid));
									while($suprow = $supquery->fetch())
									{
										$sup_name = $suprow['fullname'];
										$sup_username = $suprow['username'];	
									}

									// SKU's
									$asdquery = $db->prepare("SELECT asdid, asid, pid, asdstatus FROM assignment_detail WHERE asid = ?");
									$asdquery->execute(array($asid));
									$num_skus = $asdquery->rowcount();
					?>
					
					<tr>
						<td width="50"><?php echo($count); ?></td>
						<td>
							<a href="#"  onclick="return print_profile(<?php echo($row['asid']); ?>);"><?php echo($store_name); ?> - ST-<?php echo($store_code); ?></a>
							
						</td>
						<td><?php echo($store_city); ?></td>
						<td>
							<?php if($uid != 0 ){ echo($ba_name); ?>, <?php echo($ba_city); ?> (<?php echo($ba_username); ?>): BA-<?php echo($ba_no); } else{ echo("Undefined"); } ?></td>
						<td><?php echo($brname); ?></td>
						<td><?php echo($sup_name); ?></td>
						
						<td><?php echo($asstarttime); ?> To <?php echo($asofftime); ?></td>
						
						<td><?php if($row['asstatus'] == 0){ ?><span style="color:green;">Active</span><?php }else{ ?><span style="color:red;">Inactive</span><?php } ?></td>
						<td width="120" class='hidden-480'>
							<?php if($uid != 0){ ?>
							<a href="unassign_ba.php?asid=<?php echo($asid); ?>" class="btn" rel="tooltip" title="Un-Assign">
								<i class="fa fa-chain-broken"></i>
							</a>
							<?php } ?>
							<a href="editassignment.php?asid=<?php echo($asid); ?>" class="btn" rel="tooltip" title="Edit">
								<i class="fa fa-edit"></i>
							</a>
							<a href="javascript:Void(0);" disabled class="btn" rel="tooltip" title="Delete" onclick="return DeleteAssignment(<?php echo($asid); ?>)">
								<i class="fa fa-times"></i>
							</a>
						</td>
					</tr>
					<?php
								}
							}
						}		
					?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</body>
</html>