<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();
	if($UserAmenityLog == 0) { header("Location: main.php"); }
	chk_booking_amenity($db,$URL);
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Membership Amenites</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script language="javascript" type="text/javascript">
		function DeleteLog(amlid)
		{
			var cd;
			cd = confirm("Are you sure to delete?");
			if(cd)
			{
				window.location.href = "delete_amenitylog.php?amlid="+amlid;
			}
		}
	</script>
	<!--[if lte IE 9]>
	<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
	<script>
		$(document).ready(function () {
			$('input, textarea').placeholder();
		});
	</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<!-- HEADER START -->
<?php include("top.php"); ?>
<!-- HEADER END -->
<div class="container-fluid" id="content">
<div id="left">
	<form action="search-results.php" method="GET" class='search-form'>
		<div class="search-pane">
			<input type="text" name="search" placeholder="Search here...">
			<button type="submit">
				<i class="fa fa-search"></i>
			</button>
		</div>
	</form>
	<!-- QUICK LINKS -->
	<?php include("left.php"); ?>
	<!-- QUICK LINKS -->
</div>
<div id="main">
<div class="container-fluid">
<div class="page-header">
	<div class="pull-left">
		<h1><i class="fa fa-table"></i> Membership Amenities</h1>
	</div>
	<div class="pull-right">
	</div>
</div>
<div class="breadcrumbs">
	<ul>
		<li>
			<a href="main.php">Home</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="amenity_log.php">Membership Amenities</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<?php if($UserAddAmenityLog == 1){ ?>
		<li>
			<a href="addamenity_log.php">Add Amenity Usage</a>
		</li>
		<?php } ?>
	</ul>
	<div class="close-bread">
		<a href="#">
			<i class="fa fa-times"></i>
		</a>
	</div>
</div>
<?php
	if(isset($_REQUEST['err']))
	{
?>
<div class="alert alert-success alert-dismissable">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<?php echo($ErrMsg); ?>
</div>
<?php
	}
?>	
<div class="row">
	<div class="col-sm-12">
		<div class="box box-color box-bordered">
			<div class="box-title">
				<h3>Membership Amenity Log</h3>
			</div>
			<div class="box-content nopadding hscroll">
				<table class="table table-hover table-nomargin table-bordered dataTable">
					<thead>
					<tr>
						<th>Sr #</th>
						<th>Customer</th>
						<th>Membership</th>
						<th>Amenity</th>
						<th align="center" class='hidden-350'>Date</th>
						<th align="center" class='hidden-350'>Qty</th>
						<th class='hidden-480'>Options</th>
					</tr>
					</thead>
					<tbody>
					<?php
						$Count = 0;
						$Query = $db->prepare("SELECT * FROM amenity_log AL INNER JOIN subscriptions S ON AL.subid = S.subid INNER JOIN accounts A ON S.aid = A.aid ORDER BY AL.amlid DESC");
						$Query->execute(array(0));
						while($row = $Query->fetch())
						{
							$Count++;
							$amlid 	  = $row['amlid'];
							$subid 	  = $row['subid'];
							$slid 	  = $row['slid'];
							$bid 	  = $row['bid'];							
							$amvalue  = $row['amvalue'];
							
							if($row['amtype'] == 1)
	                      	{
	                          $AmType = "Paper Printing";
	                          $value = $row['amvalue'];
		                    }
	                      	if($row['amtype'] == 2)
	                      	{
	                        	$AmType = "Meeting Room";

	                        	$bquery = $db->prepare("SELECT * FROM booking WHERE bid=?");
	                        	$bquery->execute(array($bid));
	                        	while($brow = $bquery->fetch())
	                        	{
	                        		$seconds = $brow['btimeto'] - $brow['btimefrom'];

	                            	$days = floor($seconds / 86400);
	                            	$seconds %= 86400;

	                            	$hours = floor($seconds / 3600);
	                            	$seconds %= 3600;

	                            	$minutes = floor($seconds / 60);
	                            	$seconds %= 60;
	                              
	                            	if($hours != 0) { $conf_hrs = "$hours Hrs "; } else{ $conf_hrs = ""; }
	                            	if($minutes != 0) { $conf_mins = "$minutes Mins"; } else{ $conf_mins = ""; }

	                            	$value = $conf_hrs.$conf_mins;
	                          	}
	                      	}
		                      if($row['amtype'] == 3)
		                      {
		                          $AmType = "Conference Room";
		                          $bquery = $db->prepare("SELECT * FROM booking WHERE bid=?");
		                          $bquery->execute(array($bid));
		                          while($brow = $bquery->fetch())
		                          {

		                              $seconds = $brow['btimeto'] - $brow['btimefrom'];

		                              $days = floor($seconds / 86400);
		                              $seconds %= 86400;

		                              $hours = floor($seconds / 3600);
		                              $seconds %= 3600;

		                              $minutes = floor($seconds / 60);
		                              $seconds %= 60;
		                              
		                              if($hours != 0) { $conf_hrs = "$hours Hrs "; } else{ $conf_hrs = ""; }
		                              if($minutes != 0) { $conf_mins = "$minutes Mins"; } else{ $conf_mins = ""; }

		                              $amvalue = $conf_hrs.$conf_mins;
		                          	

		                          }
		                          $value = $amvalue;


		                      }
		                      if($row['amtype'] == 4)
		                      {
		                          $AmType = "Generator";
		                          $value = $row['amvalue'];
		                      }
		                      if($row['amtype'] == 5)
		                      {
		                          $AmType = "Electricity";
		                          $value = $row['amvalue'];
		                      }
		                      if($row['amtype'] == 6)
		                      {
		                          $AmType = "Gas";
		                          $value = $row['amvalue'];
		                      }
		                      if($row['amtype'] == 7)
		                      {
		                          $AmType = "GIMIT Card Replacement";
		                          $value = $row['amvalue'];
		                      }
		                      if($row['amtype'] == 8)
		                      {
		                          $AmType = "GIMIT Card Lost / Not Returned";
		                          $value = $row['amvalue'];
		                      }
							$amdate  = date("d/m/Y",$row['amdate']);							

							$membership  = $row['subgtno']."-".$row['subtitle'];
							$customer 	 = $row['gtno']."-".$row['aname']." (".$row['aemail'].")";
					?>
					<tr>
						<td width="10" align="left" class='hidden-350'><?php echo($Count); ?></td>
						<td width="500">
							<a href="viewamenity_log.php?amlid=<?php echo($amlid); ?>"><?php echo($customer); ?></a>
						</td>
						<td width="850"><?php echo($membership); ?></td>
						<td width="400" align="center" class='hidden-350'><?php echo($AmType); ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo($amdate); ?></td>
						<td width="200" align="center" class='hidden-350'><?php echo($value); ?></td>
						<td width="175" class='hidden-480'>
							<a href="viewamenity_log.php?amlid=<?php echo($amlid); ?>" class="btn" rel="tooltip" title="View">
								<i class="fa fa-file-o"></i>
							</a>
							<?php if($UserEditAmenityLog == 1){ ?>
							<a href="editamenity_log.php?amlid=<?php echo($amlid); ?>" class="btn" rel="tooltip" title="Edit">
								<i class="fa fa-edit"></i>
							</a>
							<?php } if($UserDeleteAmenityLog == 1){ ?>
							<a href="javascript:Void(0);" class="btn" rel="tooltip" title="Delete" onclick="return DeleteLog(<?php echo($amlid); ?>)">
								<i class="fa fa-times"></i>
							</a>
							<?php } ?>
						</td>
					</tr>
					<?php
						}
					?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</body>
</html>