<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	if(isset($_REQUEST['btnSubmit']))
	{
		add_store($db,$URL);
	}

	$strquery = $db->prepare("SELECT * FROM store ORDER BY stid ASC");
	$strquery->execute();
	while($strrow = $strquery->fetch())
	{
		$stid = $strrow['stid'];
		$store_code = $stid + 1000;

		$uquery = $db->prepare("UPDATE store SET store_code=? WHERE stid=?");
		$uquery->execute(array($store_code,$stid));
	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Create New Store</title>
	
	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- PageGuide -->
	<link rel="stylesheet" href="css/plugins/pageguide/pageguide.css">
	<!-- Fullcalendar -->
	<link rel="stylesheet" href="css/plugins/fullcalendar/fullcalendar.css">
	<link rel="stylesheet" href="css/plugins/fullcalendar/fullcalendar.print.css" media="print">
	<!-- Tagsinput -->
	<link rel="stylesheet" href="css/plugins/tagsinput/jquery.tagsinput.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- multi select -->
	<link rel="stylesheet" href="css/plugins/multiselect/multi-select.css">
	<!-- timepicker -->
	<link rel="stylesheet" href="css/plugins/timepicker/bootstrap-timepicker.min.css">
	<!-- colorpicker -->
	<link rel="stylesheet" href="css/plugins/colorpicker/colorpicker.css">
	<!-- Datepicker -->
	<link rel="stylesheet" href="css/plugins/datepicker/datepicker.css">
	<!-- Daterangepicker -->
	<link rel="stylesheet" href="css/plugins/daterangepicker/daterangepicker.css">
	<!-- Plupload -->
	<link rel="stylesheet" href="css/plugins/plupload/jquery.plupload.queue.css">
	<!-- select2 -->
	<link rel="stylesheet" href="css/plugins/select2/select2.css">
	<!-- icheck -->
	<link rel="stylesheet" href="css/plugins/icheck/all.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">


	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Masked inputs -->
	<script src="js/plugins/maskedinput/jquery.maskedinput.min.js"></script>
	<!-- TagsInput -->
	<script src="js/plugins/tagsinput/jquery.tagsinput.min.js"></script>
	<!-- Datepicker -->
	<script src="js/plugins/datepicker/bootstrap-datepicker.js"></script>
	<!-- Daterangepicker -->
	<script src="js/plugins/daterangepicker/moment.min.js"></script>
	<script src="js/plugins/daterangepicker/daterangepicker.js"></script>
	<!-- Timepicker -->
	<script src="js/plugins/timepicker/bootstrap-timepicker.min.js"></script>
	<!-- Colorpicker -->
	<script src="js/plugins/colorpicker/bootstrap-colorpicker.js"></script>
	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>
	<!-- MultiSelect -->
	<script src="js/plugins/multiselect/jquery.multi-select.js"></script>
	<!-- CKEditor -->
	<script src="js/plugins/ckeditor/ckeditor.js"></script>
	<!-- PLUpload -->
	<script src="js/plugins/plupload/plupload.full.min.js"></script>
	<script src="js/plugins/plupload/jquery.plupload.queue/jquery.plupload.queue.min.js"></script>
	<!-- Custom file upload -->
	<script src="js/plugins/fileupload/bootstrap-fileupload.min.js"></script>
	<script src="js/plugins/mockjax/jquery.mockjax.js"></script>
	<!-- select2 -->
	<script src="js/plugins/select2/select2.min.js"></script>
	<!-- icheck -->
	<script src="js/plugins/icheck/jquery.icheck.min.js"></script>
	<!-- complexify -->
	<script src="js/plugins/complexify/jquery.complexify-banlist.min.js"></script>
	<script src="js/plugins/complexify/jquery.complexify.min.js"></script>
	<!-- Mockjax -->
	<script src="js/plugins/mockjax/jquery.mockjax.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>	
	<script type="text/javascript" language="javascript">
		function openHr(hr)
		{
			var url	  		= "get_hrs.php?action=open&hr="+hr;
			var containerid = "showOpenHr";
			return GetPage(url, containerid);
		}
		function closeHr(hr)
		{
			var url	  		= "get_hrs.php?action=close&hr="+hr;
			var containerid = "showCloseHr";
			return GetPage(url, containerid);
		}
	</script>
</head>
<body class='theme-grey'>
	<!-- HEADER START -->
	<?php include("top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.html" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>Create New Store</h1>
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="stores.php">Manage Stores</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="addstore.php?">Create New Store</a>
						</li>
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<form name="Form" action="#" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
									<div id="ShowUser"></div>
									<div id="GetProduct"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-danger alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
										$stcquery = $db->prepare("SELECT stid, store_code FROM store ORDER BY stid DESC LIMIT 0,1");
										$stcquery->execute();
										if($stcquery->rowCount() == 0)
										{
											$store_code = "1000";
										}
										else
										{
											while($stcrow = $stcquery->fetch())
											{
												$old_store_code = $stcrow['store_code'];
											}
											$store_code = $old_store_code + 1;
										}
									?>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Store Code</label>
										<div class="col-sm-10">
											<span style="color:red; font-weight: bold;">ST-<?php echo($store_code); ?></span>
											<input type="hidden" name="hdnStNo" value="<?php echo($store_code); ?>">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Store Name</label>
										<div class="col-sm-10">
											<input type="text" name="txtStoreName" id="textfield" class="form-control" data-rule-required="true" data-rule-minlength="1">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Store Chain</label>
										<div class="col-sm-10">
											<select name="cboStoreChain" class="chosen-select control-label col-sm-4">
												<option value="">Select Store Chain</option>
												<?php
													$scquery = $db->prepare("SELECT * FROM store_chain ORDER BY store_chain ASC");
													$scquery->execute();
													while($scrow = $scquery->fetch())
													{
												?>
												<option value="<?php echo($scrow['store_chain']); ?>"><?php echo($scrow['store_chain']); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">City</label>
										<div class="col-sm-10">
											<select name="cboCity" class="chosen-select control-label col-sm-4">
												<option value="">Select City</option>
												<?php
													$ciquery = $db->prepare("SELECT * FROM cities ORDER BY city_name ASC");
													$ciquery->execute();
													while($cirow = $ciquery->fetch())
													{
												?>
												<option value="<?php echo($cirow['city_name']); ?>"><?php echo($cirow['city_code']); ?> - <?php echo($cirow['city_name']); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>

									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Channel</label>
										<div class="col-sm-10">
											<select name="cboChannel" class="chosen-select control-label col-sm-4">
												<option value="">Select Channel</option>
												<option value="LMT">LMT</option>
												<option value="IMT">IMT</option>
												<option value="GT">GT</option>
												<option value="Key Accounts">Key Accounts</option>
											</select>
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Coordinates</label>
										<div class="col-sm-5">
											<input type="text" name="txtLat" id="textfield" class="form-control" data-rule-required="true" data-rule-minlength="1">
										</div>
										<div class="col-sm-5">
											<input type="text" name="txtLong" id="textfield" class="form-control" data-rule-required="true" data-rule-minlength="1">
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Off Day</label>
										<div class="col-sm-10">
											<select name="cboWeeklyOff" class="chosen-select control-label col-sm-4">
												<option value="">Select Off Day</option>
												<?php
													$wquery = $db->prepare("SELECT weekday FROM weekdays");
													$wquery->execute();
													while($wrow = $wquery->fetch())
													{
												?>
												<option <?php if($wrow['weekday'] == "Tuesday"){ echo("SELECTED"); } ?> value="<?php echo($wrow['weekday']); ?>"><?php echo($wrow['weekday']); ?></option>
												<?php
													}
												?>
												
											</select>
										</div>
									</div>

									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Shift Timing</label>
										<div class="col-sm-1">
											From
										</div>
										<div class="col-sm-3">
											<select name="cboFromHrs" class="control-label col-sm-4" onchange="return openHr(this.value);">
												<option value="">Hrs</option>
												<?php
													$hrquery1 = $db->prepare("SELECT hrs FROM hrs");
													$hrquery1->execute();
													while($hrrow1 = $hrquery1->fetch())
													{
												?>
												<option <?php if($hrrow1['hrs'] == 12) { echo("SELECTED"); } ?> value="<?php echo($hrrow1['hrs']); ?>"><?php echo($hrrow1['hrs']); ?></option>
												<?php
													}
												?>
											</select>
											<select name="cboFromMins" class="control-label col-sm-4">
												<option value="00">00</option>
											</select>
										</div>
										<div class="col-sm-1">
											To
										</div>
										<div class="col-sm-3">
											<select name="cboToHrs" class="control-label col-sm-4" onchange="return closeHr(this.value);">
												<option value="">Hrs</option>
												<?php
													$hrquery2 = $db->prepare("SELECT hrs FROM hrs");
													$hrquery2->execute();
													while($hrrow2 = $hrquery2->fetch())
													{
												?>
												<option <?php if($hrrow2['hrs'] == 20) { echo("SELECTED"); } ?> value="<?php echo($hrrow2['hrs']); ?>"><?php echo($hrrow2['hrs']); ?></option>
												<?php
													}
												?>
											</select>
											<select name="cboToMins" class="control-label col-sm-4">
												<option value="00">00</option>
											</select>
										</div>

									</div>


									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Break Timing</label>
										<div class="col-sm-1">
											From
										</div>
										<div class="col-sm-3">
											<div id="showOpenHr">
											<select name="cboBrFromHrs" class="control-label col-sm-4">
												<option value="">Hrs</option>
												<?php
													$hrquery3 = $db->prepare("SELECT hrs FROM hrs");
													$hrquery3->execute();
													while($hrrow3 = $hrquery3->fetch())
													{
												?>
												<option <?php if($hrrow3['hrs'] == 16) { echo("SELECTED"); } ?> value="<?php echo($hrrow3['hrs']); ?>"><?php echo($hrrow3['hrs']); ?></option>
												<?php
													}
												?>
											</select>
											</div>
											<select name="cboBrFromMins" class="control-label col-sm-4">
												<option value="00">00</option>
											</select>
										</div>
										<div class="col-sm-1">
											To
										</div>
										<div class="col-sm-3">
											<div id="showCloseHr">
											<select name="cboBrToHrs" class="control-label col-sm-4">
												<option value="">Hrs</option>
												<?php
													$hrquery4 = $db->prepare("SELECT hrs FROM hrs");
													$hrquery4->execute();
													while($hrrow4 = $hrquery4->fetch())
													{
												?>
												<option <?php if($hrrow4['hrs'] == 17) { echo("SELECTED"); } ?> value="<?php echo($hrrow4['hrs']); ?>"><?php echo($hrrow4['hrs']); ?></option>
												<?php
													}
												?>
											</select>
											</div>
											<select name="cboBrToMins" class="control-label col-sm-4">
												<option value="00">00</option>
											</select>
										</div>

									</div>


									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Uniform</label>
										<div class="col-sm-10">
											<select name="cboUniform" class="control-label col-sm-4">
												<option value="Western">Western</option>
												<option value="Eastern">Eastern</option>
												<option value="Not Allowed">Not Allowed</option>
												<option value="Abaayah with Coat">Abaayah with Coat</option>
												<option value="Abaayah Only (LOV)">Abaayah Only (LOV)</option>
												<option value="Western">Western</option>
											</select>
										</div>
									</div>

									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Scarf</label>
										<div class="col-sm-10">
											<select name="cboScarf" class="control-label col-sm-4">
												<option value="Yes">Yes</option>
												<option value="No">No</option>
											</select>
										</div>
									</div>

									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Badge</label>
										<div class="col-sm-10">
											<select name="cboBadge" class="control-label col-sm-4">
												<option value="Yes">Yes</option>
												<option value="No">No</option>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Data Sheet</label>
										<div class="col-sm-10">
											<select name="cboDataSheet" class="control-label col-sm-4">
												<option value="Yes">Yes</option>
												<option value="No">No</option>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Device</label>
										<div class="col-sm-10">
											<select name="cboDevice" class="control-label col-sm-4">
												<option value="Allowed">Allowed</option>
												<option value="Not Allowed">Not Allowed</option>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Store Card</label>
										<div class="col-sm-10">
											<select name="cboStoreCard" class="control-label col-sm-4">
												<option value="Yes">Yes</option>
												<option value="No">No</option>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Documentation Requested</label>
										<div class="col-sm-10">
											<select name="cboDocument" class="control-label col-sm-4">
												<option value="Yes">Yes</option>
												<option value="No">No</option>
											</select>
										</div>
									</div>
								</div>	
							</div>
						</div>
					</div>
					<div class="form-actions">
						<input name="btnSubmit" type="submit" class="btn btn-primary" value="  Save  ">
						<a href="stores.php" name="btnCancel" class="btn">Cancel</a>
					</div>
				</div>
				
				
				</form>
			</div>
		</div>
	</div>
</body>
</html>
