<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	if(isset($_REQUEST['btnSubmit']))
	{
		add_slot($db,$URL);
	}
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Create New Slot</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">


	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>
	<!-- CKEditor -->
	<script src="js/plugins/ckeditor/ckeditor.js"></script>
	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->
	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
</head>

<body class='theme-grey'>
<!-- HEADER START -->
	<?php include("top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.php" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>Create New Slot</h1>
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="slots.php">Manage Slots</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="addslot.php">Create New Slot</a>
						</li>
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<form name="Form" action="#" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
									<div id="ShowUser"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-success alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
									?>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Select Location</label>
										<div class="col-sm-10">
											<select name="cboLocation" class="control-label col-sm-6">
												<?php
													$lquery = $db->prepare("SELECT * FROM locations ORDER BY lid ASC");
													$lquery->execute();
													while($lrow = $lquery->fetch())
													{
												?>
												<option value="<?php echo($lrow['lid']); ?>"><?php echo($lrow['lname']." ".$lrow['lcity']); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Select Floor</label>
										<div class="col-sm-10">
											<select name="cboFloor" class="control-label col-sm-6">
												<?php
													$flquery = $db->prepare("SELECT * FROM floors ORDER BY flid ASC");
													$flquery->execute();
													while($flrow = $flquery->fetch())
													{
												?>
												<option value="<?php echo($flrow['flid']); ?>"><?php echo($flrow['fltitle']); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Slot Type</label>
										<div class="col-sm-10">
											<input type="radio" name="rdoType" id="rdoType1" checked value="0" class='icheck-me' data-skin="square" data-color="blue">
											<label class='inline' for="rdoType1">Seat</label>
											&nbsp;&nbsp;&nbsp;
											<input type="radio" name="rdoType" id="rdoType2" value="1" class='icheck-me' data-skin="square" data-color="blue">
											<label class='inline' for="rdoType2">Conference Room</label>
											&nbsp;&nbsp;&nbsp;
											<input type="radio" name="rdoType" id="rdoType3" value="2" class='icheck-me' data-skin="square" data-color="blue">
											<label class='inline' for="rdoType3">Meeting Room</label>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Slot Title</label>
										<div class="col-sm-10">
											<input type="text" name="txtTitle" id="textfield" class="form-control" data-rule-required="true" data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Price</label>
										<div class="col-sm-2">
											<input type="text" name="txtPrice" id="textfield" class="form-control" value="0" data-rule-required="true" data-rule-minlength="1">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Timings</label>
										<div class="col-sm-10">
											<select name="cboHrsFrom" class="control-label col-sm-2">
												<option value="0">From Hrs</option>
												<?php
													$hrquery1 = $db->prepare("SELECT * FROM hrs ORDER BY hrs ASC");
													$hrquery1->execute();
													while($hrrow1 = $hrquery1->fetch())
													{
												?>
												<option value="<?php echo($hrrow1['hrs']); ?>"><?php echo($hrrow1['hours']); ?></option>
												<?php } ?>
											</select>
											<select name="cboHrsTo" class="control-label col-sm-2">
												<option value="0">To Hrs</option>
												<?php
													$hrquery2 = $db->prepare("SELECT * FROM hrs ORDER BY hrs ASC");
													$hrquery2->execute();
													while($hrrow2 = $hrquery2->fetch())
													{
												?>
												<option value="<?php echo($hrrow2['hrs']); ?>"><?php echo($hrrow2['hours']); ?></option>
												<?php } ?>
											</select>
											&nbsp;
											<span style="color: red">Note: Don't select timings if Slot Type is Seat</span>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Status</label>
										<div class="col-sm-10">
											<select name="cboStatus" class="control-label col-sm-2">
												<option value="0">Enabled</option>
												<option value="1">Disbaled</option>
											</select>
										</div>
									</div>
								</div>	
							</div>
						</div>
					</div>
					<div class="form-actions">
						<input name="btnSubmit" type="submit" class="btn btn-primary" value="  Create New Slot  ">
						<button type="button" class="btn">Cancel</button>
					</div>
				</div>
				
				
				</form>
			</div>
		</div>
	</div>
</body>
</html>
