<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	if(isset($_REQUEST['btnSubmit']))
	{
		add_recipe($db,$URL);
	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Create New Recipe</title>
	
	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>
	
	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>
	<!-- CKEditor -->
	<script src="js/plugins/ckeditor/ckeditor.js"></script>
	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.ico" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
</head>

<body class='theme-grey'>
	<!-- HEADER START -->
	<?php include("top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.html" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>Create New Recipe</h1>
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="recipes.php">Manage Recipes</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="addrecipe.php">Create New Recipe</a>
						</li>
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<form name="Form" action="#" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
									<div id="ShowUser"></div>
									<div id="GetProduct"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-danger alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Title</label>
										<div class="col-sm-10">
											<input type="text" name="txtTitle" id="textfield" class="form-control" data-rule-required="true" data-rule-minlength="1">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Status</label>
										<div class="col-sm-10">
											<select name="cboStatus" class="control-label col-sm-2">
												<option value="0">Active</option>
												<option value="1">Inactive</option>
											</select>
										</div>
									</div>
									<div class="form-group" style="background-color:#CCC; ">
										<label for="textfield" class="control-label col-sm-2"><b>Recipe</b></label>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2"></label>
										<div align="right" class="col-sm-9">
											<button id="addRow" type="button" class="btn btn-info">Add Row</button>
										</div>
									</div>
									<div class="form-group">
										<div class="col-sm-9">	
											<div class="form-group">
												<div class="col-sm-6">
													<strong>Raw Materials</strong>			
												</div>
												<div class="col-sm-6">
													<strong>Qty</strong>			
												</div>
											</div>
										</div>
										<div align="right" class="col-sm-2">
											
										</div>
									</div>
									<div id="inputFormRow">
										<div class="form-group">
											<div class="col-sm-9">	
												<div class="form-group">
													<div class="col-sm-6">
														<select name="cboRawMaterials" class="chosen-select form-control" onchange="return update_rawmaterial(<?php echo($reid); ?>,'rid',this.value);">
														<?php
															$rawquery = $db->prepare("SELECT * FROM rawmaterials R INNER JOIN rmaincategory RM ON R.rmid = RM.rmid ORDER BY R.rname ASC");
															$rawquery->execute();
															while($rawrow = $rawquery->fetch()){

															$rmid = $rawrow['rmid'];
															$rcid = $rawrow['rcid'];
															$rawmaincategory = $rawrow['rmaincategory'];

															if($rcid > 0)
															{
																$rcquery = $db->prepare("SELECT * FROM rcategory WHERE rcid=$rcid");
																$rcquery->execute();	
																while($rcrow = $rcquery->fetch())
																{
																	$rawcategory = " - ".$rcrow['rcategory'];
																}
															}
															else
															{
																$rawcategory = "";
															}	

															$rawmaterial = $rawmaincategory.$rawcategory." - ".$rawrow['rname'];	
														?>
														<option value="<?php echo($rawrow['rid']); ?>"><?php echo($rawmaterial); ?> - <?php echo($rawrow['unittype']); ?></option>
														<?php } ?>
													</select>			
													
													</div>
													<div class="col-sm-6">
														<input type="number" name="txtQty[]" step=any value="0" class="form-control">			
													</div>
												</div>
											</div>
											<div align="right" class="col-sm-2">
												<div align="right" class="input-group-append">                
					                                <button id="removeRow" disabled type="button" class="btn btn-danger">Remove</button>
					                            </div>
											</div>
										</div>
									</div>
									<div id="newRow"></div>
									<script type="text/javascript">
								        // add row
								        $("#addRow").click(function () {
								            var html = '';
											html +=	'<div id="inputFormRow">';
											html +=			'<div class="form-group">';
											html +=				'<div class="col-sm-9">';
											html +=					'<div class="form-group">';
											html +=						'<div class="col-sm-6">';
											html += 					'<select name="cboRawMaterials[]" class="chosen-select form-control m-input">';
								            html +=                    		'<option value="0">Select Raw Materials</option>';
																			<?php
																				$rquery1 = $db->prepare("SELECT * FROM rawmaterials R INNER JOIN rmaincategory RM ON R.rmid = RM.rmid ORDER BY R.rname ASC");
																				$rquery1->execute();
																				while($rrow1 = $rquery1->fetch()){

																				$rmid = $rrow1['rmid'];
																				$rcid = $rrow1['rcid'];
																				$rawmaincategory = $rrow1['rmaincategory'];

																				if($rcid > 0)
																				{
																					$rcquery = $db->prepare("SELECT * FROM rcategory WHERE rcid=$rcid");
																					$rcquery->execute();	
																					while($rcrow = $rcquery->fetch())
																					{
																						$rawcategory = " - ".$rcrow['rcategory'];
																					}
																				}
																				else
																				{
																					$rawcategory = "";
																				}	

																				$rawmaterial = $rawmaincategory.$rawcategory." - ".$rrow1['rname'];
																			?>
											html +=                    		'<option value="<?php echo($rrow1['rid']); ?>"><?php echo($rawmaterial); ?> - <?php echo($rrow1['unittype']); ?></option>';
																			<?php } ?>
											html +=                		'</select>';
											html +=						'</div>';
											html +=						'<div class="col-sm-6">';
											html += 					'<input type="number" name="txtQty[]" value="0" step=any class="form-control">';
											html +=						'</div>';
											html +=					'</div>';
											html +=				'</div>';
											html +=				'<div align="right" class="col-sm-2">';
											html +=					'<div align="right" class="input-group-append">';                
									        html +=                        '<button id="removeRow" type="button" class="btn btn-danger">Remove</button>';
									        html +=                    '</div>';
											html +=				'</div>';
											html +=			'</div>';
											html +=		'</div>';
											/*
								            html += '<div id="inputFormRow">';
								            html += '<div class="input-group mb-3">';
								            html += '<select class="form-control m-input">';
								            html +=                    '<option value="0">Select</option>';
								            html +=                    '<option value="1">One</option>';
								            html +=                    '<option value="2">Two</option>';
								            html +=                    '<option value="3">Three</option>';
								            html +=                '</select>';
								            html += '<input type="text" name="title[]" class="form-control m-input" placeholder="Enter title" autocomplete="off">';
								            html += '<div class="input-group-append">';
								            html += '<button id="removeRow" type="button" class="btn btn-danger">Remove</button>';
								            html += '</div>';
								            html += '</div>';
											*/
								            $('#newRow').append(html);
								        });

								        // remove row
								        $(document).on('click', '#removeRow', function () {
								            $(this).closest('#inputFormRow').remove();
								        });
								    </script>
									
									
								</div>	
							</div>
						</div>
					</div>
					<div class="form-actions">
						<input name="btnSubmit" type="submit" class="btn btn-primary" value="  Save  ">
						<button type="button" class="btn">Cancel</button>
					</div>
				</div>
				
				
				</form>
			</div>
		</div>
	</div>
</body>
</html>
