<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();
	if($UserConferenceReport == 0) { header("Location: main.php"); }
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Conference Room Report</title>

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Notify -->
	<link rel="stylesheet" href="css/plugins/gritter/jquery.gritter.css">	
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"s></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Notify -->
	<script src="js/plugins/gritter/jquery.gritter.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<link href='assets/css/fullcalendar.css' rel='stylesheet' />
	<link href='assets/css/fullcalendar.print.css' rel='stylesheet' media='print' />
	<script src='assets/js/jquery-1.10.2.js' type="text/javascript"></script>
	<script src='assets/js/jquery-ui.custom.min.js' type="text/javascript"></script>
	<script src='assets/js/fullcalendar.js' type="text/javascript"></script>

<script>
    $(document).ready(function() {
        var date = new Date();
      var d = date.getDate();
      var m = date.getMonth();
      var y = date.getFullYear();

      /*  className colors
      className: default(transparent), important(red), chill(pink), success(green), info(blue)
      */
      /* initialize the external events
      -----------------------------------------------------------------*/

      $('#external-events div.external-event').each(function() {

        // create an Event Object (http://arshaw.com/fullcalendar/docs/event_data/Event_Object/)
        // it doesn't need to have a start or end
        var eventObject = {
          title: $.trim($(this).text()) // use the element's text as the event title
        };

        // store the Event Object in the DOM element so we can get to it later
        $(this).data('eventObject', eventObject);

        // make the event draggable using jQuery UI
        $(this).draggable({
          zIndex: 999,
          revert: true,      // will cause the event to go back to its
          revertDuration: 0  //  original position after the drag
        });

      });


      /* initialize the calendar
      -----------------------------------------------------------------*/

      var calendar =  $('#calendar').fullCalendar({
        header: {
          left: 'title',
          center: 'agendaDay,agendaWeek,month',
          right: 'prev,next today'
        },
        editable: false,
        firstDay: 1, //  1(Monday) this can be changed to 0(Sunday) for the USA system
        selectable: false,
        defaultView: 'agendaWeek',

        axisFormat: 'h:mm',
        columnFormat: {
                  month: 'ddd',    // Mon
                  week: 'ddd d', // Mon 7
                  day: 'dddd M/d',  // Monday 9/7
                  agendaDay: 'dddd d'
              },
              titleFormat: {
                  month: 'MMMM yyyy', // September 2009
                  week: "MMMM yyyy", // September 2009
                  day: 'MMMM yyyy'                  // Tuesday, Sep 8, 2009
              },
        allDaySlot: false,
        selectHelper: true,
        select: function(start, end, allDay) {
          var title = prompt('Event Title:');
          if (title) {
            calendar.fullCalendar('renderEvent',
              {
                title: title,
                start: start,
                end: end,
                allDay: allDay
              },
              true // make the event "stick"
            );
          }
          calendar.fullCalendar('unselect');
        },
        droppable: true, // this allows things to be dropped onto the calendar !!!
        drop: function(date, allDay) { // this function is called when something is dropped

          // retrieve the dropped element's stored Event Object
          var originalEventObject = $(this).data('eventObject');

          // we need to copy it, so that multiple events don't have a reference to the same object
          var copiedEventObject = $.extend({}, originalEventObject);

          // assign it the date that was reported
          copiedEventObject.start = date;
          copiedEventObject.allDay = allDay;

          // render the event on the calendar
          // the last `true` argument determines if the event "sticks" (http://arshaw.com/fullcalendar/docs/event_rendering/renderEvent/)
          $('#calendar').fullCalendar('renderEvent', copiedEventObject, true);

          // is the "remove after drop" checkbox checked?
          if ($('#drop-remove').is(':checked')) {
            // if so, remove the element from the "Draggable Events" list
            $(this).remove();
          }

        },

        events: [
        <?php
        	$bcount = 0;
        	$bquery = $db->prepare("SELECT * FROM booking B INNER JOIN accounts A ON B.aid = A.aid WHERE B.btype = 1 AND B.bstatus = 0");
        	$bquery->execute();
        	while($brow = $bquery->fetch())
			{
				$bcount++;
				$bid  = $brow['bid'];
				$gtno  = $brow['gtno'];
				$customer  = $brow['aname'];
				$title  = $brow['btitle'];
				$byear  = date("Y",$brow['bookdate']);
				$bmonth = date("m",$brow['bookdate']) - 1;
				$bday   = date("d",$brow['bookdate']);

				//  $fromtime = explode(':', $brow['btimefrom']);
				$fromhrs  = date("H",$brow['btimefrom']);
				$frommins = date("i",$brow['btimefrom']);

				//  $totime = explode(':', $brow['btimeto']);
				$tohrs  = date("H",$brow['btimeto']);
				$tomins = date("i",$brow['btimeto']);
				if($bcount > 1) {echo(",");}
        ?> 
          	{
            	title: '<?php echo($gtno."-".$customer); ?>',
            	start: new Date(<?php echo($byear); ?>, <?php echo($bmonth); ?>, <?php echo($bday); ?>, <?php echo($fromhrs); ?>, <?php echo($frommins); ?>),
           		end: new Date(<?php echo($byear); ?>, <?php echo($bmonth); ?>, <?php echo($bday); ?>, <?php echo($tohrs); ?>, <?php echo($tomins); ?>),
            	allDay: false,
            	className: 'info',
            	url: '#modal-<?php echo($bid); ?>'
          	}
        <?php
            }
        ?> 
        ],
      });
    });
</script>
<style>
	#wrap {
		width: 1000px;
		margin: 0 auto;
		}

	#external-events {
		float: left;
		width: 150px;
		padding: 0 10px;
		text-align: left;
		}

	#external-events h4 {
		font-size: 16px;
		margin-top: 0;
		padding-top: 1em;
		}

	.external-event { /* try to mimick the look of a real event */
		margin: 10px 0;
		padding: 2px 4px;
		background: #3366CC;
		color: #fff;
		font-size: .85em;
		cursor: pointer;
		}

	#external-events p {
		margin: 1.5em 0;
		font-size: 11px;
		color: #666;
		}

	#external-events p input {
		margin: 0;
		vertical-align: middle;
		}

	#calendar {
/* 		float: right; */
        margin: 0 auto;
		width: 900px;
		background-color: #FFFFFF;
		  border-radius: 6px;
        box-shadow: 0 1px 2px #C3C3C3;
		}

</style>
</head>

<body class='theme-grey'>
<!-- HEADER START -->
	<?php include("top.php"); ?>

	<?php
		$bquery = $db->prepare("SELECT * FROM booking B INNER JOIN accounts A ON B.aid = A.aid INNER JOIN subscriptions SUB ON B.subid = SUB.subid INNER JOIN slots SL ON B.slid = SL.slid WHERE B.btype = 1 AND B.bstatus = 0");
      	$bquery->execute();
      	while($brow = $bquery->fetch())
      	{
      		$bid  = $brow['bid'];
      		$gtno  = $brow['gtno'];
      		$customer  = $brow['aname'];
      		$email  = $brow['aemail'];
      	  	$title  = $brow['btitle'];
      	  	$subtitle  = $brow['subtitle'];
      	  	$slot  = $brow['sltitle'];
      	  	$byear  = date("Y",$brow['bookdate']);
      	  	$bmonth = date("m",$brow['bookdate']) - 1;
        	$bday   = date("d",$brow['bookdate']);

    	//  $fromtime = explode(':', $brow['btimefrom']);
    	    $fromhrs  = date("H",$brow['btimefrom']);
    	    $frommins = date("i",$brow['btimefrom']);

    	//  $totime = explode(':', $brow['btimeto']);
    	    $tohrs  = date("H",$brow['btimeto']);
    	    $tomins = date("i",$brow['btimeto']);

    	    $from  = date("h:i A",$brow['btimefrom']);
			$to    = date("h:i A",$brow['btimeto']);
	?>
	<div id="modal-<?php echo($bid); ?>" class="modal fade" role="dialog">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					<h4 class="modal-title" id="myModalLabel"><?php echo($title); ?></h4>
				</div>
				<!-- /.modal-header -->
				<div class="modal-body">
					<table width="100%" cellspacing="5" cellpadding="5">
						<tr>
							<td height="30" width="20%" align="left"><b>Customer Name</b></td>
							<td width="80%" align="left"><?php echo($gtno); ?> <?php echo($customer); ?> (<?php echo($email); ?>)</td>
						</tr>
						<tr>
							<td height="30" width="20%" align="left"><b>Membership</b></td>
							<td width="80%" align="left"><?php echo($brow['subgtno']); ?> <?php echo($subtitle); ?></td>
						</tr>
						<tr>
							<td height="30" width="20%" align="left"><b>Room #</b></td>
							<td width="80%" align="left"><?php echo($slot); ?></td>
						</tr>
						<tr>
							<td height="30" width="20%" align="left"><b>Book Date</b></td>
							<td width="80%" align="left"><?php echo(date("d-m-Y",$brow['bookdate'])); ?></td>
						</tr>
						<tr>
							<td height="30" width="20%" align="left"><b>Timings</b></td>
							<td width="80%" align="left">From: <?php echo($from); ?> To: <?php echo($to); ?></td>
						</tr>
						<tr>
							<td height="30" width="20%" align="left"><b>Num of Hrs</b></td>
							<td width="80%" align="left"><?php echo($brow['numhrs']); ?></td>
						</tr>
					</table>
				</div>
				<!-- /.modal-body -->
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
				<!-- /.modal-footer -->
			</div>
			<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>
	<!-- /#modal-1.modal fade -->
	<?php } ?>

	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.php" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>Conference Room Report</h1>
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="conference_room_report.php">Conference Room Report</a>
							<i class="fa fa-angle-right"></i>
						</li>
						
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<form name="Form" action="#" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
									<div id="ShowGtNo"></div>
									<div id="ShowMembership"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-success alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
									?>
								
									
									<div class="form-group">
										<div class="col-sm-12">
											<div id='wrap'>
												<div id='calendar'></div>
												<div style='clear:both'></div>
											</div>
										</div>
									</div>
								</div>	
							</div>
						</div>
					</div>
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
									<div id="ShowGtNo"></div>
									<div id="ShowMembership"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-success alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Membership</label>
										<div class="col-sm-10">
											<select name="cboMembership" class="chosen-select control-label col-sm-6" onchange="return chkMembership();">
												<?php
													$mquery = $db->prepare("SELECT * FROM subscriptions WHERE subarchived = 0 AND substatus = 0 ORDER BY subid ASC");
													$mquery->execute();
													while($mrow = $mquery->fetch())
													{
												?>
												<option value="<?php echo($mrow['subid']); ?>"><?php echo($mrow['subgtno']."-".$mrow['subtitle']); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Amenity Type <span style="color: red;">*</span></label>
										<div class="col-sm-10">
											<select name="cboAmenityType" class="chosen-select control-label col-sm-6">
												<option value="1">Paper Printing</option>
												<option value="2">Meeting Room</option>
												<option value="3">Confernece Room</option>
												<option value="4">Generator</option>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Date</label>
										<div class="col-sm-10">
											<input type="text" name="txtDate" id="textfield" value="<?php echo(date("d/m/Y")); ?>" class="form-control datepick">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Qty</label>
										<div class="col-sm-10">
											<input type="text" name="txtQty" id="textfield" class="form-control" value="0" data-rule-required="true" data-rule-minlength="1">
										</div>
									</div>									
								</div>	
							</div>
						</div>

					</div>
					<div class="form-actions">
						<input name="btnSubmit" type="submit" class="btn btn-primary" value="  Add Amenity Log  ">
						<button type="button" class="btn">Cancel</button>
					</div>
				</div>
				</form>
			</div>
		</div>
	</div>
</body>
</html>
